/*
 * Decompiled with CFR 0.152.
 */
package com.spatialdev.osm.model;

import com.spatialdev.osm.model.OSMMeta;
import com.spatialdev.osm.model.OSMNode;
import com.spatialdev.osm.model.OSMRelation;
import com.spatialdev.osm.model.OSMWay;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OSMDataSet {
    private ArrayList<String> notes = new ArrayList();
    private OSMMeta meta;
    private LinkedHashMap<Long, OSMNode> nodes = new LinkedHashMap();
    private LinkedHashMap<Long, OSMWay> ways = new LinkedHashMap();
    private LinkedHashMap<Long, OSMRelation> relations = new LinkedHashMap();
    private Set<Long> wayNodeIds = new HashSet<Long>();
    private List<OSMNode> standaloneNodes = new ArrayList<OSMNode>();
    private List<OSMWay> closedWays = new ArrayList<OSMWay>();
    private List<OSMWay> openWays = new ArrayList<OSMWay>();

    public void createNote(String note) {
        this.notes.add(note);
    }

    public void createMeta(String osmBase) {
        this.meta = new OSMMeta(osmBase);
    }

    public OSMNode createNode(String idStr, String latStr, String lonStr, String versionStr, String timestampStr, String changesetStr, String uidStr, String userStr) {
        OSMNode n = new OSMNode(idStr, latStr, lonStr, versionStr, timestampStr, changesetStr, uidStr, userStr);
        this.nodes.put(n.getId(), n);
        return n;
    }

    public OSMWay createWay(String idStr, String versionStr, String timestampStr, String changesetStr, String uidStr, String userStr) {
        OSMWay w = new OSMWay(idStr, versionStr, timestampStr, changesetStr, uidStr, userStr);
        this.ways.put(w.getId(), w);
        return w;
    }

    public OSMRelation createRelation(String idStr, String versionStr, String timestampStr, String changesetStr, String uidStr, String userStr) {
        OSMRelation r = new OSMRelation(idStr, versionStr, timestampStr, changesetStr, uidStr, userStr);
        this.relations.put(r.getId(), r);
        return r;
    }

    void postProcessing() {
        Set<Long> wayKeys = this.ways.keySet();
        for (Long key : wayKeys) {
            OSMWay w = this.ways.get(key);
            w.linkNodes(this.nodes, this.wayNodeIds);
            if (w.isClosed()) {
                this.closedWays.add(w);
                continue;
            }
            this.openWays.add(w);
        }
        Set<Long> nodeKeys = this.nodes.keySet();
        for (Long key : nodeKeys) {
            if (this.wayNodeIds.contains(key)) continue;
            OSMNode n = this.nodes.get(key);
            this.standaloneNodes.add(n);
        }
        Set<Long> relationKeys = this.relations.keySet();
        for (Long key : relationKeys) {
            OSMRelation r = this.relations.get(key);
            r.link(this.nodes, this.ways, this.relations);
        }
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public int getWayCount() {
        return this.ways.size();
    }

    public int getRelationCount() {
        return this.relations.size();
    }

    public ArrayList<String> getNotes() {
        return this.notes;
    }

    public OSMMeta getMeta() {
        return this.meta;
    }

    public Map<Long, OSMNode> getNodes() {
        return this.nodes;
    }

    public List<OSMNode> getStandaloneNodes() {
        return this.standaloneNodes;
    }

    public int getStandaloneNodesCount() {
        return this.standaloneNodes.size();
    }

    public Map<Long, OSMWay> getWays() {
        return this.ways;
    }

    public List<OSMWay> getClosedWays() {
        return this.closedWays;
    }

    public int getClosedWaysCount() {
        return this.closedWays.size();
    }

    public List<OSMWay> getOpenWays() {
        return this.openWays;
    }

    public int getOpenWaysCount() {
        return this.openWays.size();
    }

    public Map<Long, OSMRelation> getRelations() {
        return this.relations;
    }
}

