/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.util;

import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import com.mapbox.mapboxsdk.views.util.Projection;

public class GeometryMath {
    public static final double DEG2RAD = Math.PI / 180;
    public static final double RAD2DEG = 57.29577951308232;

    public static final Rect getBoundingBoxForRotatedRectangle(Rect rect, float centerX, float centerY, float angle, Rect reuse) {
        Rect out = GeometryMath.reusable(reuse);
        if (angle % 360.0f == 0.0f) {
            out.set(rect);
            return out;
        }
        double theta = (double)angle * (Math.PI / 180);
        double sinTheta = Math.sin(theta);
        double cosTheta = Math.cos(theta);
        double dx1 = (float)rect.left - centerX;
        double dy1 = (float)rect.top - centerY;
        double newX1 = (double)centerX - dx1 * cosTheta + dy1 * sinTheta;
        double newY1 = (double)centerY - dx1 * sinTheta - dy1 * cosTheta;
        double dx2 = (float)rect.right - centerX;
        double dy2 = (float)rect.top - centerY;
        double newX2 = (double)centerX - dx2 * cosTheta + dy2 * sinTheta;
        double newY2 = (double)centerY - dx2 * sinTheta - dy2 * cosTheta;
        double dx3 = (float)rect.left - centerX;
        double dy3 = (float)rect.bottom - centerY;
        double newX3 = (double)centerX - dx3 * cosTheta + dy3 * sinTheta;
        double newY3 = (double)centerY - dx3 * sinTheta - dy3 * cosTheta;
        double dx4 = (float)rect.right - centerX;
        double dy4 = (float)rect.bottom - centerY;
        double newX4 = (double)centerX - dx4 * cosTheta + dy4 * sinTheta;
        double newY4 = (double)centerY - dx4 * sinTheta - dy4 * cosTheta;
        out.set((int)GeometryMath.Min4(newX1, newX2, newX3, newX4), (int)GeometryMath.Min4(newY1, newY2, newY3, newY4), (int)GeometryMath.Max4(newX1, newX2, newX3, newX4), (int)GeometryMath.Max4(newY1, newY2, newY3, newY4));
        return out;
    }

    public static final PointF reusable(PointF reuse) {
        PointF out = reuse != null ? reuse : new PointF();
        return out;
    }

    public static final Point reusable(Point reuse) {
        Point out = reuse != null ? reuse : new Point();
        return out;
    }

    public static final RectF reusable(RectF reuse) {
        RectF out = reuse != null ? reuse : new RectF();
        return out;
    }

    public static final Rect reusable(Rect reuse) {
        Rect out = reuse != null ? reuse : new Rect();
        return out;
    }

    public static PointF rotatePoint(float centerX, float centerY, PointF point, float angle, PointF reuse) {
        PointF out = GeometryMath.reusable(reuse);
        double rotationRadians = (double)angle * (Math.PI / 180);
        double sin = Math.sin(rotationRadians);
        double cos = Math.cos(rotationRadians);
        double x = point.x - centerX;
        double y = point.y - centerY;
        double xnew = x * cos - y * sin + (double)centerX;
        double ynew = x * sin + y * cos + (double)centerY;
        out.set((float)(xnew + (double)centerX), (float)(ynew + (double)centerY));
        return out;
    }

    private static double Min4(double a, double b, double c, double d) {
        return Math.floor(Math.min(Math.min(a, b), Math.min(c, d)));
    }

    private static double Max4(double a, double b, double c, double d) {
        return Math.ceil(Math.max(Math.max(a, b), Math.max(c, d)));
    }

    public static int getNextSquareNumberAbove(float factor) {
        int out = 0;
        int cur = 1;
        int i = 1;
        while (!((float)cur > factor)) {
            out = i++;
            cur *= 2;
        }
        return out;
    }

    public static int mod(int number, int modulus) {
        if (number > 0) {
            return number % modulus;
        }
        while (number < 0) {
            number += modulus;
        }
        return number;
    }

    public static float leftShift(float value, float multiplier) {
        return (float)((double)value * Math.pow(2.0, multiplier));
    }

    public static float rightShift(float value, float multiplier) {
        return (float)((double)value / Math.pow(2.0, multiplier));
    }

    public static double rightShift(double value, float multiplier) {
        return value / Math.pow(2.0, multiplier);
    }

    public static Rect viewPortRect(float zoomLevel, Projection projection, Rect reuse) {
        Rect out = GeometryMath.reusable(reuse);
        Rect screenRect = projection.getScreenRect();
        int worldSize_2 = Projection.mapSize(zoomLevel) >> 1;
        out.set(screenRect);
        out.offset(worldSize_2, worldSize_2);
        return out;
    }

    public static Rect viewPortRectForTileDrawing(float zoomLevel, Projection projection, Rect reuse) {
        Rect out = GeometryMath.reusable(reuse);
        Rect screenRect = projection.getScreenRect();
        int worldSize_2 = Projection.mapSize(zoomLevel) >> 1;
        int roundWorldSize_2 = Projection.mapSize((float)Math.floor(zoomLevel)) >> 1;
        float scale = (float)roundWorldSize_2 / (float)worldSize_2;
        out.set((int)(scale * (float)screenRect.left), (int)(scale * (float)screenRect.top), (int)(scale * (float)screenRect.right), (int)(scale * (float)screenRect.bottom));
        out.offset(roundWorldSize_2, roundWorldSize_2);
        return out;
    }

    public static Rect viewPortRect(Projection projection, Rect reuse) {
        return GeometryMath.viewPortRect(projection.getZoomLevel(), projection, reuse);
    }

    public static Rect viewPortRectForTileDrawing(Projection projection, Rect reuse) {
        return GeometryMath.viewPortRectForTileDrawing(projection.getZoomLevel(), projection, reuse);
    }
}

