/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.util;

import com.mapbox.mapboxsdk.geometry.BoundingBox;
import com.mapbox.mapboxsdk.geometry.LatLng;
import java.util.List;

public class GeoUtils {
    public static BoundingBox findBoundingBoxForGivenLocations(List<LatLng> coordinates, Double padding) {
        double west = 0.0;
        double east = 0.0;
        double north = 0.0;
        double south = 0.0;
        for (int lc = 0; lc < coordinates.size(); ++lc) {
            LatLng loc = coordinates.get(lc);
            if (lc == 0) {
                north = loc.getLatitude();
                south = loc.getLatitude();
                west = loc.getLongitude();
                east = loc.getLongitude();
                continue;
            }
            if (loc.getLatitude() > north) {
                north = loc.getLatitude();
            } else if (loc.getLatitude() < south) {
                south = loc.getLatitude();
            }
            if (loc.getLongitude() < west) {
                west = loc.getLongitude();
                continue;
            }
            if (!(loc.getLongitude() > east)) continue;
            east = loc.getLongitude();
        }
        if (padding != null) {
            north += padding.doubleValue();
            south -= padding.doubleValue();
            west -= padding.doubleValue();
            east += padding.doubleValue();
        }
        return new BoundingBox(north, east, south, west);
    }
}

