/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.tileprovider.tilesource;

import android.os.AsyncTask;
import com.mapbox.mapboxsdk.tileprovider.MapTile;
import com.mapbox.mapboxsdk.tileprovider.tilesource.TileLayer;
import com.mapbox.mapboxsdk.tileprovider.tilesource.WebSourceTileLayer;
import com.mapbox.mapboxsdk.util.NetworkUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import org.json.JSONArray;
import org.json.JSONObject;

public class BingTileLayer
extends WebSourceTileLayer {
    public static String TAG = "BingTileLayer";
    public static final String IMAGERYSET_AERIAL = "Aerial";
    public static final String IMAGERYSET_AERIALWITHLABELS = "AerialWithLabels";
    public static final String IMAGERYSET_ROAD = "Road";
    private static final String BASE_URL_PATTERN = "http://dev.virtualearth.net/REST/V1/Imagery/Metadata/%s?mapVersion=v1&output=json&key=%s";
    private String mBingMapKey = "";
    private String mStyle = "Road";
    private boolean mHasMetadata = false;

    public BingTileLayer(String key) {
        super("Bing Tile Layer", BASE_URL_PATTERN, false);
        this.setBingMapKey(key);
        this.setMinimumZoomLevel(1.0f);
        this.setMaximumZoomLevel(22.0f);
        this.getMetadata();
    }

    @Override
    public String getTileURL(MapTile aTile, boolean hdpi) {
        if (!this.mHasMetadata) {
            this.getMetadata();
        }
        return this.mUrl.replace("{quadkey}", this.quadTree(aTile));
    }

    @Override
    public String getCacheKey() {
        return "Bing " + this.getStyle();
    }

    public String getBingMapKey() {
        return this.mBingMapKey;
    }

    private void setBingMapKey(String key) {
        this.mBingMapKey = key;
    }

    public String getStyle() {
        return this.mStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TileLayer setStyle(String style) {
        if (!style.equals(this.mStyle)) {
            String string2 = this.mStyle;
            synchronized (string2) {
                this.mStyle = style;
                this.mHasMetadata = false;
            }
        }
        this.mStyle = style;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMetadata() {
        try {
            BingTileLayer bingTileLayer = this;
            synchronized (bingTileLayer) {
                if (this.mHasMetadata) {
                    return;
                }
                RetrieveMetadata rm = new RetrieveMetadata(this.mBingMapKey, this.mStyle){

                    protected void onPostExecute(Boolean success) {
                        BingTileLayer.this.mHasMetadata = success == Boolean.TRUE;
                    }
                };
                rm.execute(new Void[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getInstanceFromJSON(String jsonContent) throws Exception {
        if (jsonContent == null) {
            throw new Exception("JSON to parse is null");
        }
        JSONObject json = new JSONObject(jsonContent);
        int statusCode = json.getInt("statusCode");
        if (statusCode != 200) {
            throw new Exception("Status code = " + statusCode);
        }
        if ("ValidCredentials".compareToIgnoreCase(json.getString("authenticationResultCode")) != 0) {
            throw new Exception("authentication result code = " + json.getString("authenticationResultCode"));
        }
        JSONArray resultsSet = json.getJSONArray("resourceSets");
        if (resultsSet == null || resultsSet.length() < 1) {
            throw new Exception("No results set found in json response");
        }
        if (resultsSet.getJSONObject(0).getInt("estimatedTotal") <= 0) {
            throw new Exception("No resource found in json response");
        }
        JSONObject resource = resultsSet.getJSONObject(0).getJSONArray("resources").getJSONObject(0);
        if (resource.has("ZoomMin")) {
            this.mMinimumZoomLevel = resource.getInt("ZoomMin");
        }
        if (resource.has("ZoomMax")) {
            this.mMaximumZoomLevel = resource.getInt("ZoomMax");
        }
        String imageBaseUrl = resource.getString("imageUrl");
        String imageUrl = imageBaseUrl.replace("{subdomain}", resource.getJSONArray("imageUrlSubdomains").getString(0));
        return imageUrl;
    }

    private static String readAll(Reader rd) throws IOException {
        int cp;
        StringBuilder sb = new StringBuilder();
        while ((cp = rd.read()) != -1) {
            sb.append((char)cp);
        }
        return sb.toString();
    }

    private String quadTree(MapTile tile) {
        StringBuilder quadKey = new StringBuilder();
        for (int i = tile.getZ(); i > 0; --i) {
            int digit = 0;
            int mask = 1 << i - 1;
            if ((tile.getX() & mask) != 0) {
                ++digit;
            }
            if ((tile.getY() & mask) != 0) {
                digit += 2;
            }
            quadKey.append("" + digit);
        }
        return quadKey.toString();
    }

    private class RetrieveMetadata
    extends AsyncTask<Void, Void, Boolean> {
        String mKey;
        String mStyle;

        public RetrieveMetadata(String key, String style) {
            this.mKey = key;
            this.mStyle = style;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground(Void ... params) {
            try {
                BingTileLayer bingTileLayer = BingTileLayer.this;
                synchronized (bingTileLayer) {
                    String metadataUrl;
                    if (BingTileLayer.this.mHasMetadata) {
                        return null;
                    }
                    String url = String.format(BingTileLayer.BASE_URL_PATTERN, this.mStyle, this.mKey);
                    HttpURLConnection connection = NetworkUtils.getHttpURLConnection(new URL(url));
                    BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream(), Charset.forName("UTF-8")));
                    String content = BingTileLayer.readAll(rd);
                    BingTileLayer.this.mUrl = metadataUrl = BingTileLayer.this.getInstanceFromJSON(content).replace("{culture}", "en");
                    return Boolean.TRUE;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return Boolean.FALSE;
            }
        }
    }
}

