/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.overlay;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.overlay.Marker;
import com.mapbox.mapboxsdk.util.BitmapUtils;
import com.mapbox.mapboxsdk.views.NumberBitmapDrawable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ClusterMarker
extends Marker {
    private List<Marker> mMarkerList = new ArrayList<Marker>();

    public ClusterMarker() {
        super("", "", new LatLng(0.0, 0.0));
    }

    public ClusterMarker(Marker marker) {
        super("", "", new LatLng(0.0, 0.0));
        this.addMarkerToCluster(marker);
    }

    @Override
    public Drawable getMarker(int stateBitset) {
        if (this.mMarker == null && this.context != null) {
            this.setDefaultClusterMarker(this.context);
        }
        return this.mMarker;
    }

    public void setDefaultClusterMarker(Context context) {
        BitmapFactory.Options opts = BitmapUtils.getBitmapOptions(context.getResources().getDisplayMetrics());
        NumberBitmapDrawable numberBitmapDrawable = new NumberBitmapDrawable(context.getResources(), BitmapFactory.decodeResource((Resources)context.getResources(), (int)R.drawable.clusteri, (BitmapFactory.Options)opts), this.mMarkerList.size());
        this.setMarker((Drawable)numberBitmapDrawable, true);
    }

    public void addMarkerToCluster(Marker marker) {
        this.mMarkerList.add(marker);
    }

    public void addMarkersToCluster(Collection<Marker> markers) {
        this.mMarkerList.addAll(markers);
    }

    public void updatePosition() {
        double centroidX = 0.0;
        double centroidY = 0.0;
        for (Marker marker1 : this.mMarkerList) {
            centroidX += marker1.getPoint().getLongitude();
            centroidY += marker1.getPoint().getLatitude();
        }
        this.setPoint(new LatLng(centroidY /= (double)this.mMarkerList.size(), centroidX /= (double)this.mMarkerList.size()));
    }

    public List<Marker> getMarkersReadOnly() {
        return Collections.unmodifiableList(this.mMarkerList);
    }

    public void setClusterItemCount(int count) {
        if (this.mMarker instanceof NumberBitmapDrawable) {
            ((NumberBitmapDrawable)this.mMarker).setCount(count);
        }
    }

    public void setTextPaint(Paint paint) {
        if (this.mMarker instanceof NumberBitmapDrawable) {
            ((NumberBitmapDrawable)this.mMarker).setTextPaint(paint);
        }
    }

    public static interface OnDrawClusterListener {
        public Drawable drawCluster(ClusterMarker var1);
    }
}

