/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.offline;

import android.content.Context;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.util.MapboxUtils;
import java.util.ArrayList;

public class OfflineMapURLGenerator {
    private ArrayList<Bounds> bounds = new ArrayList();
    private int minimumZoom;
    private int maximumZoom;
    private int urlCount;

    public OfflineMapURLGenerator(double minLat, double maxLat, double minLon, double maxLon, int minimumZ, int maximumZ) {
        this.minimumZoom = minimumZ;
        this.maximumZoom = maximumZ;
        this.urlCount = 0;
        for (int zoom = minimumZ; zoom <= maximumZ; ++zoom) {
            int tilesPerSide = Double.valueOf(Math.pow(2.0, zoom)).intValue();
            int minX = Double.valueOf(Math.floor((minLon + 180.0) / 360.0 * (double)tilesPerSide)).intValue();
            int maxX = Double.valueOf(Math.floor((maxLon + 180.0) / 360.0 * (double)tilesPerSide)).intValue();
            int minY = Double.valueOf(Math.floor((1.0 - Math.log(Math.tan(Math.toRadians(maxLat)) + 1.0 / Math.cos(Math.toRadians(maxLat))) / 3.1415927410125732) / 2.0 * (double)tilesPerSide)).intValue();
            int maxY = Double.valueOf(Math.floor((1.0 - Math.log(Math.tan(Math.toRadians(minLat)) + 1.0 / Math.cos(Math.toRadians(minLat))) / 3.1415927410125732) / 2.0 * (double)tilesPerSide)).intValue();
            this.bounds.add(new Bounds(minX, maxX, minY, maxY));
            this.urlCount += (maxX - minX + 1) * (maxY - minY + 1);
        }
    }

    public int getURLCount() {
        return this.urlCount;
    }

    public String getURLForIndex(Context context, String mapID, MapboxConstants.RasterImageQuality imageQuality, int index) {
        int zoom;
        if (index >= this.getURLCount()) {
            return null;
        }
        for (zoom = this.minimumZoom; zoom < this.maximumZoom; ++zoom) {
            int boundsIndex = zoom - this.minimumZoom;
            Bounds bounds = this.bounds.get(boundsIndex);
            int urlsInThisLevel = (bounds.maxX - bounds.minX + 1) * (bounds.maxY - bounds.minY + 1);
            if (index < urlsInThisLevel) break;
            index -= urlsInThisLevel;
        }
        Bounds bounds = this.bounds.get(zoom - this.minimumZoom);
        int yCount = bounds.maxY - bounds.minY + 1;
        int x = index / yCount + bounds.minX;
        int y = index % yCount + bounds.minY;
        return MapboxUtils.getMapTileURL(context, mapID, zoom, x, y, imageQuality);
    }

    private static class Bounds {
        public int minX;
        public int maxX;
        public int minY;
        public int maxY;

        public Bounds(int minX, int maxX, int minY, int maxY) {
            this.minX = minX;
            this.maxX = maxX;
            this.minY = minY;
            this.maxY = maxY;
        }
    }
}

