/*
 * Decompiled with CFR 0.152.
 */
package com.cocoahero.android.geojson;

import android.os.Parcel;
import android.os.Parcelable;
import com.cocoahero.android.geojson.GeoJSONObject;
import com.cocoahero.android.geojson.Geometry;
import com.cocoahero.android.geojson.Position;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Point
extends Geometry {
    private Position mPosition;
    public static final Parcelable.Creator<Point> CREATOR = new Parcelable.Creator<Point>(){

        public Point createFromParcel(Parcel in) {
            return (Point)GeoJSONObject.readParcel(in);
        }

        public Point[] newArray(int size) {
            return new Point[size];
        }
    };

    public Point() {
    }

    public Point(JSONObject json) {
        super(json);
        this.setPosition(json.optJSONArray("coordinates"));
    }

    public Point(JSONArray position) {
        this.setPosition(position);
    }

    public Point(Position position) {
        this.setPosition(position);
    }

    public Point(double latitude, double longitude) {
        this.mPosition = new Position(latitude, longitude);
    }

    public Point(double latitude, double longitude, double altitude) {
        this.mPosition = new Position(latitude, longitude, altitude);
    }

    public Position getPosition() {
        return this.mPosition;
    }

    public void setPosition(Position position) {
        this.mPosition = position;
    }

    public void setPosition(JSONArray position) {
        this.mPosition = position != null ? new Position(position) : null;
    }

    @Override
    public String getType() {
        return "Point";
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject json = super.toJSON();
        if (this.mPosition != null) {
            json.put("coordinates", (Object)this.mPosition.toJSON());
        }
        return json;
    }
}

