/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.tileprovider.tilesource;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextUtils;
import android.util.Log;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.tileprovider.MapTile;
import com.mapbox.mapboxsdk.tileprovider.MapTileCache;
import com.mapbox.mapboxsdk.tileprovider.modules.MapTileDownloader;
import com.mapbox.mapboxsdk.tileprovider.tilesource.MapboxTileLayer;
import com.mapbox.mapboxsdk.tileprovider.tilesource.TileLayer;
import com.mapbox.mapboxsdk.util.NetworkUtils;
import com.mapbox.mapboxsdk.views.util.TileLoadedListener;
import com.mapbox.mapboxsdk.views.util.TilesLoadedListener;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import uk.co.senab.bitmapcache.CacheableBitmapDrawable;

public class WebSourceTileLayer
extends TileLayer
implements MapboxConstants {
    private static final String TAG = "WebSourceTileLayer";
    private AtomicInteger activeThreads = new AtomicInteger(0);
    protected boolean mEnableSSL = false;
    private static final Paint compositePaint = new Paint(2);

    public WebSourceTileLayer(String pId, String url) {
        this(pId, url, false);
    }

    public WebSourceTileLayer(String pId, String url, boolean enableSSL) {
        super(pId, url);
        this.initialize(pId, url, enableSSL);
    }

    private boolean checkThreadControl() {
        return this.activeThreads.get() == 0;
    }

    @Override
    public TileLayer setURL(String aUrl) {
        Object[] objectArray = new Object[1];
        Object object = objectArray[0] = this.mEnableSSL ? "" : "s";
        if (aUrl.contains(String.format(MAPBOX_LOCALE, "http%s://", objectArray))) {
            super.setURL(aUrl.replace(String.format(MAPBOX_LOCALE, "http%s://", this.mEnableSSL ? "" : "s"), String.format(MAPBOX_LOCALE, "http%s://", this.mEnableSSL ? "s" : "")));
        } else {
            super.setURL(aUrl);
        }
        return this;
    }

    protected void initialize(String pId, String aUrl, boolean enableSSL) {
        this.mEnableSSL = enableSSL;
        this.setURL(aUrl);
    }

    public String[] getTileURLs(MapTile aTile, boolean hdpi) {
        String url = this.getTileURL(aTile, hdpi);
        if (!TextUtils.isEmpty((CharSequence)url)) {
            return new String[]{url};
        }
        return null;
    }

    public String getTileURL(MapTile aTile, boolean hdpi) {
        return this.parseUrlForTile(this.mUrl, aTile, hdpi);
    }

    protected String parseUrlForTile(String url, MapTile aTile, boolean hdpi) {
        return url.replace("{z}", String.valueOf(aTile.getZ())).replace("{x}", String.valueOf(aTile.getX())).replace("{y}", String.valueOf(aTile.getY())).replace("{2x}", hdpi ? "@2x" : "");
    }

    private Bitmap compositeBitmaps(Bitmap source, Bitmap dest) {
        Canvas canvas = new Canvas(dest);
        canvas.drawBitmap(source, 0.0f, 0.0f, compositePaint);
        return dest;
    }

    public CacheableBitmapDrawable getDrawableFromTile(MapTileDownloader downloader, MapTile aTile, boolean hdpi) {
        if (downloader.isNetworkAvailable()) {
            TilesLoadedListener listener = downloader.getTilesLoadedListener();
            boolean tempHDPI = hdpi;
            if (this instanceof MapboxTileLayer) {
                tempHDPI = false;
            }
            String[] urls = this.getTileURLs(aTile, tempHDPI);
            CacheableBitmapDrawable result = null;
            Bitmap resultBitmap = null;
            if (urls != null) {
                MapTileCache cache = downloader.getCache();
                if (listener != null) {
                    listener.onTilesLoadStarted();
                }
                for (String url : urls) {
                    Bitmap bitmap = this.getBitmapFromURL(aTile, url, cache);
                    if (bitmap == null) continue;
                    resultBitmap = resultBitmap == null ? bitmap : this.compositeBitmaps(bitmap, resultBitmap);
                }
                if (resultBitmap != null) {
                    result = cache.putTileBitmap(aTile, resultBitmap);
                }
                if (this.checkThreadControl() && listener != null) {
                    listener.onTilesLoaded();
                }
            }
            if (result != null) {
                TileLoadedListener listener2 = downloader.getTileLoadedListener();
                result = listener2 != null ? listener2.onTileLoaded(result) : result;
            }
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getBitmapFromURL(MapTile mapTile, String url, MapTileCache aCache) {
        this.activeThreads.incrementAndGet();
        if (TextUtils.isEmpty((CharSequence)url)) {
            this.activeThreads.decrementAndGet();
            return null;
        }
        try {
            HttpURLConnection connection = NetworkUtils.getHttpURLConnection(new URL(url));
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)connection.getInputStream());
            if (bitmap != null) {
                aCache.putTileInMemoryCache(mapTile, bitmap);
            }
            Bitmap bitmap2 = bitmap;
            return bitmap2;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("Error downloading MapTile: " + url + ":" + e));
        }
        finally {
            this.activeThreads.decrementAndGet();
        }
        return null;
    }
}

