/*
 * Decompiled with CFR 0.152.
 */
package com.spatialdev.osm.renderer;

import android.graphics.Paint;
import android.graphics.Path;
import com.mapbox.mapboxsdk.views.MapView;
import com.spatialdev.osm.model.OSMWay;
import com.spatialdev.osm.renderer.OSMPath;

public class OSMPolygon
extends OSMPath {
    private static final int DEFAULT_A = 50;
    private static final int DEFAULT_R = 62;
    private static final int DEFAULT_G = 107;
    private static final int DEFAULT_B = 255;
    private static final int DEFAULT_SELECTED_A = 180;
    private static final int DEFAULT_SELECTED_R = 255;
    private static final int DEFAULT_SELECTED_G = 140;
    private static final int DEFAULT_SELECTED_B = 0;
    private int a;
    private int r;
    private int g;
    private int b;

    protected OSMPolygon(OSMWay w, MapView mv) {
        this(w, mv, 50, 62, 107, 255);
    }

    @Override
    public void select() {
        this.paint.setARGB(180, 255, 140, 0);
    }

    @Override
    public void deselect() {
        this.paint.setARGB(this.a, this.r, this.g, this.b);
    }

    protected OSMPolygon(OSMWay w, MapView mv, int a, int r, int g, int b) {
        super(w, mv);
        this.a = a;
        this.r = r;
        this.g = g;
        this.b = b;
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setARGB(a, r, g, b);
    }

    @Override
    void clipOrDrawPath(Path path, double[] projectedPoint, double[] nextProjectedPoint, double[] screenPoint) {
        if (this.pathLineToReady) {
            path.lineTo((float)screenPoint[0], (float)screenPoint[1]);
        } else {
            path.moveTo((float)screenPoint[0], (float)screenPoint[1]);
            this.pathLineToReady = true;
        }
    }
}

