/*
 * Decompiled with CFR 0.152.
 */
package com.spatialdev.osm.model;

import com.spatialdev.osm.model.OSMElement;
import com.spatialdev.osm.model.OSMNode;
import com.spatialdev.osm.model.OSMWay;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlSerializer;

public class OSMRelation
extends OSMElement {
    private LinkedList<RelationMember> nodeMembers = new LinkedList();
    private LinkedList<RelationMember> wayMembers = new LinkedList();
    private LinkedList<RelationMember> relationMembers = new LinkedList();
    private LinkedList<OSMNode> linkedNodes = new LinkedList();
    private LinkedList<OSMWay> linkedWays = new LinkedList();
    private LinkedList<OSMRelation> linkedRelations = new LinkedList();
    private int unlinkedMembersCount = 0;

    public OSMRelation(String idStr, String versionStr, String timestampStr, String changesetStr, String uidStr, String userStr) {
        super(idStr, versionStr, timestampStr, changesetStr, uidStr, userStr);
    }

    @Override
    void xml(XmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.startTag(null, "relation");
        if (this.isModified()) {
            xmlSerializer.attribute(null, "action", "modify");
        }
        this.setOsmElementXmlAttributes(xmlSerializer);
        this.setRelationXmlMembers(xmlSerializer);
        super.xml(xmlSerializer);
        xmlSerializer.endTag(null, "relation");
    }

    private void setRelationXmlMembers(XmlSerializer xmlSerializer) throws IOException {
        for (RelationMember mem : this.nodeMembers) {
            this.writeXmlMember(mem, xmlSerializer);
        }
        for (RelationMember mem : this.wayMembers) {
            this.writeXmlMember(mem, xmlSerializer);
        }
        for (RelationMember mem : this.relationMembers) {
            this.writeXmlMember(mem, xmlSerializer);
        }
    }

    private void writeXmlMember(RelationMember mem, XmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.startTag(null, "member");
        xmlSerializer.attribute(null, "type", mem.type);
        xmlSerializer.attribute(null, "ref", String.valueOf(mem.ref));
        xmlSerializer.attribute(null, "role", mem.role);
        xmlSerializer.endTag(null, "member");
    }

    public void addNodeRef(long id, String role) {
        this.nodeMembers.add(new RelationMember(id, "node", role));
    }

    public void addWayRef(long id, String role) {
        this.wayMembers.add(new RelationMember(id, "way", role));
    }

    public void addRelationRef(long id, String role) {
        this.relationMembers.add(new RelationMember(id, "relation", role));
    }

    int link(Map<Long, OSMNode> nodes, Map<Long, OSMWay> ways, Map<Long, OSMRelation> relations) {
        int unlinkedNodes = this.linkNodes(nodes);
        int unlinkedWays = this.linkWays(ways);
        int unlinkedRelations = this.linkRelations(relations);
        this.unlinkedMembersCount = unlinkedNodes + unlinkedWays + unlinkedRelations;
        return this.unlinkedMembersCount;
    }

    private int linkNodes(Map<Long, OSMNode> nodes) {
        int unlinkedCount = 0;
        for (RelationMember mem : this.nodeMembers) {
            OSMNode node = nodes.get(mem.ref);
            if (node == null) {
                ++unlinkedCount;
                continue;
            }
            node.addRelation(this);
            mem.linkedElement = node;
            this.linkedNodes.push(node);
        }
        return unlinkedCount;
    }

    private int linkWays(Map<Long, OSMWay> ways) {
        int unlinkedCount = 0;
        for (RelationMember mem : this.wayMembers) {
            OSMWay way = ways.get(mem.ref);
            if (way == null) {
                ++unlinkedCount;
                continue;
            }
            way.addRelation(this);
            mem.linkedElement = way;
            this.linkedWays.push(way);
        }
        return unlinkedCount;
    }

    private int linkRelations(Map<Long, OSMRelation> relations) {
        int unlinkedCount = 0;
        for (RelationMember mem : this.relationMembers) {
            OSMRelation rel = relations.get(mem.ref);
            if (rel == null) {
                ++unlinkedCount;
                continue;
            }
            rel.addRelation(this);
            mem.linkedElement = rel;
            this.linkedRelations.push(rel);
        }
        return unlinkedCount;
    }

    public void addRelation(OSMRelation relation) {
        this.linkedRelations.push(relation);
    }

    public List<OSMRelation> getRelations() {
        return this.linkedRelations;
    }

    public int getUnlinkedMemberCount() {
        return this.unlinkedMembersCount;
    }

    private class RelationMember {
        public Long ref;
        public String type;
        public String role;
        public OSMElement linkedElement;

        public RelationMember(Long ref, String type, String role) {
            this.ref = ref;
            this.type = type;
            this.role = role;
        }
    }
}

