/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.tileprovider.tilesource;

import android.text.TextUtils;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.tileprovider.tilesource.TileJsonTileLayer;
import com.mapbox.mapboxsdk.tileprovider.tilesource.TileLayer;
import com.mapbox.mapboxsdk.util.MapboxUtils;
import com.mapbox.mapboxsdk.views.util.constants.MapViewConstants;
import java.util.Locale;

public class MapboxTileLayer
extends TileJsonTileLayer
implements MapViewConstants,
MapboxConstants {
    private static final String TAG = "MapboxTileLayer";
    private String mId;

    public MapboxTileLayer(String mapId) {
        this(mapId, true);
    }

    public MapboxTileLayer(String mapId, boolean enableSSL) {
        super(mapId, mapId, enableSSL);
    }

    @Override
    protected void initialize(String pId, String aUrl, boolean enableSSL) {
        this.mId = pId;
        super.initialize(pId, aUrl, enableSSL);
    }

    @Override
    public TileLayer setURL(String aUrl) {
        if (!(TextUtils.isEmpty((CharSequence)aUrl) || aUrl.toLowerCase(Locale.US).contains("http://") || aUrl.toLowerCase(Locale.US).contains("https://"))) {
            super.setURL("https://a.tiles.mapbox.com/v4/" + aUrl + "/{z}/{x}/{y}{2x}.png?access_token=" + MapboxUtils.getAccessToken());
        } else {
            super.setURL(aUrl);
        }
        return this;
    }

    @Override
    protected String getBrandedJSONURL() {
        String url = String.format(MAPBOX_LOCALE, "https://a.tiles.mapbox.com/v4/%s.json?access_token=%s&secure=1", this.mId, MapboxUtils.getAccessToken());
        if (!this.mEnableSSL) {
            url = url.replace("https://", "http://");
            url = url.replace("&secure=1", "");
        }
        return url;
    }

    @Override
    public String getCacheKey() {
        return this.mId;
    }
}

