/*
 * Decompiled with CFR 0.152.
 */
package com.spatialdev.osm.model;

import com.spatialdev.osm.renderer.OSMPath;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlSerializer;

public abstract class OSMElement {
    private static LinkedList<OSMElement> selectedElements = new LinkedList();
    private static boolean selectedElementsChanged = false;
    private static LinkedList<OSMElement> modifiedElements = new LinkedList();
    protected long id;
    protected long version;
    protected String timestamp;
    protected long changeset;
    protected long uid;
    protected String user;
    protected boolean selected = false;
    protected boolean modified = false;
    protected Geometry jtsGeom;
    protected Map<String, String> tags = new LinkedHashMap<String, String>();
    protected Map<String, String> originalTags = new LinkedHashMap<String, String>();
    protected OSMPath osmPath;

    public static LinkedList<OSMElement> getSelectedElements() {
        return selectedElements;
    }

    public static LinkedList<OSMElement> getModifiedElements() {
        return modifiedElements;
    }

    public static boolean hasSelectedElementsChanged() {
        if (selectedElementsChanged) {
            selectedElementsChanged = false;
            return true;
        }
        return false;
    }

    public static void deselectAll() {
        for (OSMElement el : selectedElements) {
            selectedElementsChanged = true;
            el.deselect();
        }
    }

    public OSMElement(String idStr, String versionStr, String timestampStr, String changesetStr, String uidStr, String userStr) {
        this.id = Long.valueOf(idStr);
        this.version = Long.valueOf(versionStr);
        this.timestamp = timestampStr;
        this.changeset = Long.valueOf(changesetStr);
        this.uid = Long.valueOf(uidStr);
        this.user = userStr;
    }

    void xml(XmlSerializer xmlSerializer) throws IOException {
        Set<String> tagKeys = this.tags.keySet();
        for (String tagKey : tagKeys) {
            xmlSerializer.startTag(null, "tag");
            xmlSerializer.attribute(null, "k", tagKey);
            xmlSerializer.attribute(null, "v", this.tags.get(tagKey));
            xmlSerializer.endTag(null, "tag");
        }
    }

    protected void setOsmElementXmlAttributes(XmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.attribute(null, "id", String.valueOf(this.id));
        if (this.modified) {
            xmlSerializer.attribute(null, "action", "modify");
        }
        xmlSerializer.attribute(null, "version", String.valueOf(this.version));
        xmlSerializer.attribute(null, "changeset", String.valueOf(this.changeset));
        xmlSerializer.attribute(null, "timestamp", this.timestamp);
    }

    public void addOrEditTag(String k, String v) {
        String origVal = this.tags.get(k);
        if (v.equals(origVal)) {
            return;
        }
        this.modified = true;
        this.tags.put(k, v);
        modifiedElements.add(this);
    }

    public void deleteTag(String k) {
        String origVal = this.tags.get(k);
        if (origVal == null) {
            return;
        }
        this.modified = true;
        this.tags.remove(k);
        modifiedElements.add(this);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void addParsedTag(String k, String v) {
        this.originalTags.put(k, v);
        this.tags.put(k, v);
    }

    public long getId() {
        return this.id;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public int getTagCount() {
        return this.tags.size();
    }

    public void setJTSGeom(Geometry geom) {
        this.jtsGeom = geom;
    }

    public Geometry getJTSGeom() {
        return this.jtsGeom;
    }

    public void select() {
        selectedElementsChanged = true;
        this.selected = true;
        selectedElements.push(this);
        if (this.osmPath != null) {
            this.osmPath.select();
        }
    }

    public void deselect() {
        selectedElementsChanged = true;
        this.selected = false;
        selectedElements.remove(this);
        if (this.osmPath != null) {
            this.osmPath.deselect();
        }
    }

    public void toggle() {
        if (this.selected) {
            this.deselect();
        } else {
            this.select();
        }
    }

    public boolean isSelected() {
        return this.selected;
    }
}

