package com.mapbox.mapboxsdk.views.util.constants;

public interface MapViewLayouts {
    /**
     * Special value for the alignment requested by a View. TOP_LEFT means that the location
     * will at the top left the View.
     */
    public static final int TOP_LEFT = 1;
    /**
     * Special value for the alignment requested by a View. TOP_RIGHT means that the location
     * will be centered at the top of the View.
     */
    public static final int TOP_CENTER = 2;
    /**
     * Special value for the alignment requested by a View. TOP_RIGHT means that the location
     * will at the top right the View.
     */
    public static final int TOP_RIGHT = 3;
    /**
     * Special value for the alignment requested by a View. CENTER_LEFT means that the location
     * will at the center left the View.
     */
    public static final int CENTER_LEFT = 4;
    /**
     * Special value for the alignment requested by a View. CENTER means that the location will
     * be centered at the center of the View.
     */
    public static final int CENTER = 5;
    /**
     * Special value for the alignment requested by a View. CENTER_RIGHT means that the location
     * will at the center right the View.
     */
    public static final int CENTER_RIGHT = 6;
    /**
     * Special value for the alignment requested by a View. BOTTOM_LEFT means that the location
     * will be at the bottom left of the View.
     */
    public static final int BOTTOM_LEFT = 7;
    /**
     * Special value for the alignment requested by a View. BOTTOM_CENTER means that the
     * location will be centered at the bottom of the view.
     */
    public static final int BOTTOM_CENTER = 8;
    /**
     * Special value for the alignment requested by a View. BOTTOM_RIGHT means that the location
     * will be at the bottom right of the View.
     */
    public static final int BOTTOM_RIGHT = 9;
}
