/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.util;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.mapbox.mapboxsdk.api.ILatLng;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.exceptions.MissingTokenException;

public class MapboxUtils
implements MapboxConstants {
    private static final String TAG = "MapboxUtils";
    private static String accessToken = null;
    private static String versionNumber;

    public static String getAccessToken() {
        if (TextUtils.isEmpty((CharSequence)accessToken)) {
            Log.e((String)TAG, (String)"Missing Token", (Throwable)new MissingTokenException());
            return null;
        }
        return accessToken;
    }

    public static void setAccessToken(String accessToken) {
        MapboxUtils.accessToken = accessToken;
    }

    public static String getVersionNumber() {
        return versionNumber;
    }

    public static void setVersionNumber(String versionNumber) {
        MapboxUtils.versionNumber = versionNumber;
    }

    public static String getUserAgent() {
        StringBuffer sb = new StringBuffer("Mapbox Android SDK");
        if (MapboxUtils.getVersionNumber() != null) {
            sb.append("/");
            sb.append(MapboxUtils.getVersionNumber());
        }
        return sb.toString();
    }

    public static String qualityExtensionForImageQuality(MapboxConstants.RasterImageQuality imageQuality) {
        String qualityExtension;
        switch (imageQuality) {
            case MBXRasterImageQualityPNG32: {
                qualityExtension = "png32";
                break;
            }
            case MBXRasterImageQualityPNG64: {
                qualityExtension = "png64";
                break;
            }
            case MBXRasterImageQualityPNG128: {
                qualityExtension = "png128";
                break;
            }
            case MBXRasterImageQualityPNG256: {
                qualityExtension = "png256";
                break;
            }
            case MBXRasterImageQualityJPEG70: {
                qualityExtension = "jpg70";
                break;
            }
            case MBXRasterImageQualityJPEG80: {
                qualityExtension = "jpg80";
                break;
            }
            case MBXRasterImageQualityJPEG90: {
                qualityExtension = "jpg90";
                break;
            }
            default: {
                qualityExtension = "png";
            }
        }
        return qualityExtension;
    }

    public static String markerIconURL(Context context, String size, String symbol, String color) {
        StringBuffer marker = new StringBuffer("pin-");
        if (size.toLowerCase(MapboxConstants.MAPBOX_LOCALE).charAt(0) == 'l') {
            marker.append("l");
        } else if (size.toLowerCase(MapboxConstants.MAPBOX_LOCALE).charAt(0) == 's') {
            marker.append("s");
        } else {
            marker.append("m");
        }
        if (!TextUtils.isEmpty((CharSequence)symbol)) {
            marker.append(String.format("-%s+", symbol));
        } else {
            marker.append("+");
        }
        marker.append(color.replaceAll("#", ""));
        marker.append(".png");
        marker.append("?access_token=");
        marker.append(MapboxUtils.getAccessToken());
        return String.format(MAPBOX_LOCALE, "https://a.tiles.mapbox.com/v4/marker/%s", marker);
    }

    public static String getMapTileURL(Context context, String mapID, int zoom, int x, int y, MapboxConstants.RasterImageQuality imageQuality) {
        return String.format(MAPBOX_LOCALE, "https://a.tiles.mapbox.com/v4/%s/%d/%d/%d%s.%s?access_token=%s", mapID, zoom, x, y, "", MapboxUtils.qualityExtensionForImageQuality(imageQuality), MapboxUtils.getAccessToken());
    }

    public static String getUTFGridString(ILatLng latLng, int zoom) {
        int tilesPerSide = Double.valueOf(Math.pow(2.0, zoom)).intValue();
        int x = Double.valueOf(Math.floor((latLng.getLongitude() + 180.0) / 360.0 * (double)tilesPerSide)).intValue();
        int y = Double.valueOf(Math.floor((1.0 - Math.log(Math.tan(latLng.getLatitude() * 3.1415927410125732 / 180.0) + 1.0 / Math.cos(latLng.getLatitude() * 3.1415927410125732 / 180.0)) / 3.1415927410125732) / 2.0 * (double)tilesPerSide)).intValue();
        return String.format("%d/%d/%d", zoom, x, y);
    }
}

