/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.overlay;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Log;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.overlay.Icon;
import com.mapbox.mapboxsdk.overlay.ItemizedOverlay;
import com.mapbox.mapboxsdk.util.BitmapUtils;
import com.mapbox.mapboxsdk.views.InfoWindow;
import com.mapbox.mapboxsdk.views.MapView;
import com.mapbox.mapboxsdk.views.util.Projection;
import com.mapbox.mapboxsdk.views.util.constants.MapViewConstants;

public class Marker
implements MapViewConstants {
    private static String TAG = "Marker";
    public static final int ITEM_STATE_FOCUSED_MASK = 4;
    public static final int ITEM_STATE_PRESSED_MASK = 1;
    public static final int ITEM_STATE_SELECTED_MASK = 2;
    private int group = 0;
    private boolean mClustered;
    private final RectF mMyLocationRect = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
    private final RectF mMyLocationPreviousRect = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
    protected final PointF mCurMapCoords = new PointF();
    private Context context;
    private MapView mapView;
    private Icon icon;
    private boolean isUsingMakiIcon = true;
    protected String mUid;
    protected LatLng mLatLng;
    protected Drawable mMarker;
    protected PointF mAnchor = null;
    private String mTitle = "";
    private String mDescription = "";
    private String mSubDescription = "";
    private Drawable mImage;
    private Object mRelatedObject;
    private boolean bubbleShowing;
    private ItemizedOverlay mParentHolder;
    private Drawable mDefaultPinDrawable;
    private int mDefaultPinRes = R.drawable.defpin;
    private InfoWindow mToolTip;

    public Marker(String title, String description, LatLng latLng) {
        this(null, title, description, latLng);
    }

    public Marker(MapView mv, String aTitle, String aDescription, LatLng aLatLng) {
        this.mapView = mv;
        if (mv != null) {
            this.context = mv.getContext();
        }
        this.setTitle(aTitle);
        this.setDescription(aDescription);
        this.mLatLng = aLatLng;
        Log.d((String)TAG, (String)("markerconst" + mv + aTitle + aDescription + aLatLng));
        this.mParentHolder = null;
        this.mAnchor = DEFAULT_PIN_ANCHOR;
    }

    public Drawable getDefaultPinDrawable() {
        if (this.mDefaultPinDrawable == null && this.context != null) {
            BitmapFactory.Options opts = BitmapUtils.getBitmapOptions(this.context.getResources().getDisplayMetrics());
            this.mDefaultPinDrawable = new BitmapDrawable(this.context.getResources(), BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)this.mDefaultPinRes, (BitmapFactory.Options)opts));
        }
        return this.mDefaultPinDrawable;
    }

    public Marker addTo(MapView mv) {
        this.mapView = mv;
        if (this.context == null) {
            this.context = mv.getContext();
        }
        return this;
    }

    public boolean hasContent() {
        return !TextUtils.isEmpty((CharSequence)this.mTitle) || !TextUtils.isEmpty((CharSequence)this.mDescription) || !TextUtils.isEmpty((CharSequence)this.mSubDescription) || this.mImage != null;
    }

    protected InfoWindow createTooltip(MapView mv) {
        return new InfoWindow(R.layout.tooltip, mv);
    }

    public InfoWindow getToolTip(MapView mv) {
        if (this.mToolTip == null || this.mToolTip.getMapView() != mv) {
            this.mToolTip = this.createTooltip(mv);
        }
        return this.mToolTip;
    }

    public void setToolTip(InfoWindow mToolTip) {
        this.mToolTip = mToolTip;
    }

    public void closeToolTip() {
        if (this.mToolTip != null && this.mToolTip.equals(this.mToolTip.getMapView().getCurrentTooltip())) {
            this.mToolTip.getMapView().closeCurrentTooltip();
        }
    }

    public void blur() {
        if (this.mParentHolder != null) {
            this.mParentHolder.blurItem(this);
        }
    }

    public String getUid() {
        return this.mUid;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public LatLng getPoint() {
        return this.mLatLng;
    }

    public void setTitle(String aTitle) {
        this.mTitle = aTitle;
    }

    public void setDescription(String aDescription) {
        this.mDescription = aDescription;
    }

    public void setSubDescription(String aSubDescription) {
        this.mSubDescription = aSubDescription;
    }

    public void setImage(Drawable anImage) {
        this.mImage = anImage;
    }

    public void setRelatedObject(Object o) {
        this.mRelatedObject = o;
    }

    public void setPoint(LatLng point) {
        this.mLatLng = point;
        this.invalidate();
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getSubDescription() {
        return this.mSubDescription;
    }

    public Drawable getImage() {
        return this.mImage;
    }

    public Object getRelatedObject() {
        return this.mRelatedObject;
    }

    public ItemizedOverlay getParentHolder() {
        return this.mParentHolder;
    }

    public void setParentHolder(ItemizedOverlay o) {
        this.mParentHolder = o;
    }

    public Drawable getMarker(int stateBitset) {
        if (this.mMarker == null) {
            this.setMarker(this.getDefaultPinDrawable(), true);
        }
        Marker.setState(this.mMarker, stateBitset);
        return this.mMarker;
    }

    public void setMarker(Drawable marker, boolean isMakiIcon) {
        this.mMarker = marker;
        if (marker != null) {
            marker.setBounds(0, 0, marker.getIntrinsicWidth(), marker.getIntrinsicHeight());
            this.isUsingMakiIcon = isMakiIcon;
        }
        this.invalidate();
    }

    public void setMarker(Drawable marker) {
        this.setMarker(marker, false);
    }

    public void setHotspot(HotspotPlace place) {
        if (place == null) {
            place = HotspotPlace.BOTTOM_CENTER;
        }
        switch (place) {
            case NONE: 
            case UPPER_LEFT_CORNER: {
                this.mAnchor.set(0.0f, 0.0f);
                break;
            }
            case BOTTOM_CENTER: {
                this.mAnchor.set(0.5f, 1.0f);
                break;
            }
            case LOWER_LEFT_CORNER: {
                this.mAnchor.set(0.0f, 1.0f);
                break;
            }
            case LOWER_RIGHT_CORNER: {
                this.mAnchor.set(1.0f, 1.0f);
                break;
            }
            case CENTER: {
                this.mAnchor.set(0.5f, 0.5f);
                break;
            }
            case LEFT_CENTER: {
                this.mAnchor.set(0.0f, 0.5f);
                break;
            }
            case RIGHT_CENTER: {
                this.mAnchor.set(1.0f, 0.5f);
                break;
            }
            case TOP_CENTER: {
                this.mAnchor.set(0.5f, 0.0f);
                break;
            }
            case UPPER_RIGHT_CORNER: {
                this.mAnchor.set(1.0f, 0.0f);
            }
        }
        this.invalidate();
    }

    public Point getAnchor() {
        if (this.mAnchor != null) {
            int markerWidth = this.getWidth();
            int markerHeight = this.getHeight();
            return new Point((int)(-this.mAnchor.x * (float)markerWidth), (int)(-this.mAnchor.y * (float)markerHeight));
        }
        return new Point(0, 0);
    }

    public Point getAnchor(HotspotPlace place) {
        int markerWidth = this.getWidth();
        int markerHeight = this.getHeight();
        return this.getHotspot(place, markerWidth, markerHeight);
    }

    public void setAnchor(PointF anchor) {
        this.mAnchor = anchor;
        this.invalidate();
    }

    public static void setState(Drawable drawable2, int stateBitset) {
        int[] states = new int[3];
        int index = 0;
        if ((stateBitset & 1) > 0) {
            states[index++] = 16842919;
        }
        if ((stateBitset & 2) > 0) {
            states[index++] = 0x10100A1;
        }
        if ((stateBitset & 4) > 0) {
            states[index++] = 16842908;
        }
        drawable2.setState(states);
    }

    public Drawable getDrawable() {
        return this.mMarker;
    }

    public int getWidth() {
        if (this.mMarker == null) {
            return 0;
        }
        return this.mMarker.getIntrinsicWidth();
    }

    public int getHeight() {
        if (this.mMarker == null) {
            return 0;
        }
        int result = this.getRealHeight();
        if (this.isUsingMakiIcon) {
            result /= 2;
        }
        return result;
    }

    public int getRealHeight() {
        if (this.mMarker == null) {
            return 0;
        }
        return this.mMarker.getIntrinsicHeight();
    }

    public PointF getPositionOnScreen(Projection projection, PointF reuse) {
        return projection.toPixels(this.mCurMapCoords, reuse);
    }

    public PointF getDrawingPositionOnScreen(Projection projection, PointF reuse) {
        reuse = this.getPositionOnScreen(projection, reuse);
        Point point = this.getAnchor();
        reuse.offset((float)point.x, (float)point.y);
        return reuse;
    }

    protected RectF getDrawingBounds(Projection projection, RectF reuse) {
        if (reuse == null) {
            reuse = new RectF();
        }
        PointF position = this.getPositionOnScreen(projection, null);
        int w = this.getWidth();
        int h = this.isUsingMakiIcon ? this.getRealHeight() : this.getHeight();
        float left = position.x - this.mAnchor.x * (float)w;
        float right = left + (float)w;
        float top = position.y - this.mAnchor.y * (float)h;
        float bottom = top + (float)h;
        reuse.set(left, top, right, bottom);
        return reuse;
    }

    protected RectF getMapDrawingBounds(Projection projection, RectF reuse) {
        if (reuse == null) {
            reuse = new RectF();
        }
        projection.toMapPixels(this.mLatLng, this.mCurMapCoords);
        int w = this.getWidth();
        int h = this.getHeight();
        float x = this.mCurMapCoords.x - this.mAnchor.x * (float)w;
        float y = this.mCurMapCoords.y - this.mAnchor.y * (float)h;
        reuse.set(x, y, x + (float)w, y + (float)(h * 2));
        return reuse;
    }

    protected RectF getHitBounds(Projection projection, RectF reuse) {
        return this.getDrawingBounds(projection, reuse);
    }

    public PointF getHotspotScale(HotspotPlace place, PointF reuse) {
        if (reuse == null) {
            reuse = new PointF();
        }
        if (place == null) {
            place = HotspotPlace.BOTTOM_CENTER;
        }
        switch (place) {
            case NONE: 
            case UPPER_LEFT_CORNER: {
                reuse.set(0.0f, 0.0f);
                break;
            }
            case BOTTOM_CENTER: {
                reuse.set(0.5f, 1.0f);
                break;
            }
            case LOWER_LEFT_CORNER: {
                reuse.set(0.0f, 1.0f);
                break;
            }
            case LOWER_RIGHT_CORNER: {
                reuse.set(1.0f, 1.0f);
                break;
            }
            case CENTER: {
                reuse.set(0.5f, 0.5f);
                break;
            }
            case LEFT_CENTER: {
                reuse.set(0.0f, 0.5f);
                break;
            }
            case RIGHT_CENTER: {
                reuse.set(1.0f, 0.5f);
                break;
            }
            case TOP_CENTER: {
                reuse.set(0.5f, 0.0f);
                break;
            }
            case UPPER_RIGHT_CORNER: {
                reuse.set(1.0f, 0.0f);
            }
        }
        return reuse;
    }

    public Point getHotspot(HotspotPlace place, int w, int h) {
        PointF scale = this.getHotspotScale(place, null);
        return new Point((int)((float)(-w) * scale.x), (int)((float)(-h) * scale.y));
    }

    public void showBubble(InfoWindow tooltip, MapView aMapView, boolean panIntoView) {
        Point markerH = this.getAnchor();
        Point tooltipH = this.getAnchor(HotspotPlace.TOP_CENTER);
        markerH.offset(-tooltipH.x, tooltipH.y);
        tooltip.open(this, this.getPoint(), markerH.x, markerH.y);
        if (panIntoView) {
            aMapView.getController().animateTo(this.getPoint());
        }
        this.bubbleShowing = true;
        tooltip.setBoundMarker(this);
    }

    public Marker setIcon(Icon aIcon) {
        this.icon = aIcon;
        this.icon.setMarker(this);
        this.isUsingMakiIcon = true;
        return this;
    }

    public boolean isUsingMakiIcon() {
        return this.isUsingMakiIcon;
    }

    public PointF getPositionOnMap() {
        return this.mCurMapCoords;
    }

    public void updateDrawingPosition() {
        if (this.mapView == null) {
            return;
        }
        this.getMapDrawingBounds(this.mapView.getProjection(), this.mMyLocationRect);
    }

    public void invalidate() {
        if (this.mapView == null) {
            return;
        }
        this.mMyLocationPreviousRect.set(this.mMyLocationRect);
        this.updateDrawingPosition();
        final RectF newRect = new RectF(this.mMyLocationRect);
        newRect.union(this.mMyLocationPreviousRect);
        this.mapView.post(new Runnable(){

            @Override
            public void run() {
                Marker.this.mapView.invalidateMapCoordinates(newRect);
            }
        });
    }

    public static enum HotspotPlace {
        NONE,
        CENTER,
        BOTTOM_CENTER,
        TOP_CENTER,
        RIGHT_CENTER,
        LEFT_CENTER,
        UPPER_RIGHT_CORNER,
        LOWER_RIGHT_CORNER,
        UPPER_LEFT_CORNER,
        LOWER_LEFT_CORNER;

    }
}

