/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.views;

import android.os.Handler;
import android.view.ScaleGestureDetector;
import com.mapbox.mapboxsdk.views.MapView;

public class MapViewScaleGestureDetectorListener
implements ScaleGestureDetector.OnScaleGestureListener {
    private static String TAG = "MapViewScaleGestureDetectorListener";
    private float lastFocusX;
    private float lastFocusY;
    private float firstSpan;
    private final MapView mapView;
    private boolean scaling;
    private float currentScale;

    public MapViewScaleGestureDetectorListener(MapView mv) {
        this.mapView = mv;
    }

    public boolean onScaleBegin(ScaleGestureDetector detector) {
        this.lastFocusX = detector.getFocusX();
        this.lastFocusY = detector.getFocusY();
        this.firstSpan = detector.getCurrentSpan();
        this.currentScale = 1.0f;
        if (!this.mapView.isAnimating()) {
            this.mapView.setIsAnimating(true);
            this.mapView.getController().aboutToStartAnimation(this.lastFocusX, this.lastFocusY);
            this.scaling = true;
        }
        return true;
    }

    public boolean onScale(ScaleGestureDetector detector) {
        if (!this.scaling) {
            return true;
        }
        this.currentScale = detector.getCurrentSpan() / this.firstSpan;
        float focusX = detector.getFocusX();
        float focusY = detector.getFocusY();
        this.mapView.setScale(this.currentScale);
        this.mapView.getController().offsetDeltaScroll(this.lastFocusX - focusX, this.lastFocusY - focusY);
        this.mapView.getController().panBy(this.lastFocusX - focusX, this.lastFocusY - focusY, true);
        this.lastFocusX = focusX;
        this.lastFocusY = focusY;
        return true;
    }

    public void onScaleEnd(ScaleGestureDetector detector) {
        if (!this.scaling) {
            return;
        }
        Handler handler = new Handler();
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                float preZoom = MapViewScaleGestureDetectorListener.this.mapView.getZoomLevel(false);
                float newZoom = (float)(Math.log(MapViewScaleGestureDetectorListener.this.currentScale) / Math.log(2.0) + (double)preZoom);
                MapViewScaleGestureDetectorListener.this.mapView.setAnimatedZoom(newZoom);
                MapViewScaleGestureDetectorListener.this.mapView.getController().onAnimationEnd();
                MapViewScaleGestureDetectorListener.this.scaling = false;
            }
        }, 100L);
    }
}

