/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.overlay;

import android.content.Context;
import android.graphics.Canvas;
import android.view.MotionEvent;
import com.mapbox.mapboxsdk.api.ILatLng;
import com.mapbox.mapboxsdk.overlay.MapEventsReceiver;
import com.mapbox.mapboxsdk.overlay.Overlay;
import com.mapbox.mapboxsdk.views.MapView;
import com.mapbox.mapboxsdk.views.util.Projection;

public class MapEventsOverlay
extends Overlay {
    private MapEventsReceiver mReceiver;

    public MapEventsOverlay(Context ctx, MapEventsReceiver receiver) {
        super(ctx);
        this.mReceiver = receiver;
        this.setOverlayIndex(0);
    }

    @Override
    protected void draw(Canvas c, MapView osmv, boolean shadow) {
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent e, MapView mapView) {
        Projection proj = mapView.getProjection();
        ILatLng p = proj.fromPixels(e.getX(), e.getY());
        return this.mReceiver.singleTapUpHelper(p);
    }

    @Override
    public boolean onLongPress(MotionEvent e, MapView mapView) {
        Projection proj = mapView.getProjection();
        ILatLng p = proj.fromPixels(e.getX(), e.getY());
        return this.mReceiver.longPressHelper(p);
    }
}

