/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.overlay;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.KeyEvent;
import android.view.MotionEvent;
import com.mapbox.mapboxsdk.views.MapView;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class Overlay {
    private static AtomicInteger sOrdinal = new AtomicInteger();
    protected float mScale;
    private static final Rect mRect = new Rect();
    private boolean mEnabled = true;
    private int mOverlayIndex = 3;
    public static final int MAPEVENTSOVERLAY_INDEX = 0;
    public static final int PATHOVERLAY_INDEX = 1;
    public static final int USERLOCATIONOVERLAY_INDEX = 2;

    public Overlay() {
    }

    public Overlay(Context ctx) {
        this.mScale = ctx.getResources().getDisplayMetrics().density;
    }

    public Overlay setContext(Context ctx) {
        this.mScale = ctx.getResources().getDisplayMetrics().density;
        return this;
    }

    public void setOverlayIndex(int overlayIndex) {
        this.mOverlayIndex = overlayIndex;
    }

    public int getOverlayIndex() {
        return this.mOverlayIndex;
    }

    public void setEnabled(boolean pEnabled) {
        this.mEnabled = pEnabled;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    protected static final int getSafeMenuId() {
        return sOrdinal.getAndIncrement();
    }

    protected abstract void draw(Canvas var1, MapView var2, boolean var3);

    public void onDetach(MapView mapView) {
    }

    public boolean onKeyDown(int keyCode, KeyEvent event, MapView mapView) {
        return false;
    }

    public boolean onKeyUp(int keyCode, KeyEvent event, MapView mapView) {
        return false;
    }

    public boolean onTouchEvent(MotionEvent event, MapView mapView) {
        return false;
    }

    public boolean onTrackballEvent(MotionEvent event, MapView mapView) {
        return false;
    }

    public boolean onDoubleTap(MotionEvent e, MapView mapView) {
        return false;
    }

    public boolean onDoubleTapEvent(MotionEvent e, MapView mapView) {
        return false;
    }

    public boolean onSingleTapConfirmed(MotionEvent e, MapView mapView) {
        return false;
    }

    public boolean onDown(MotionEvent e, MapView mapView) {
        return false;
    }

    public boolean onFling(MotionEvent pEvent1, MotionEvent pEvent2, float pVelocityX, float pVelocityY, MapView pMapView) {
        return false;
    }

    public boolean onLongPress(MotionEvent e, MapView mapView) {
        return false;
    }

    public boolean onScroll(MotionEvent pEvent1, MotionEvent pEvent2, float pDistanceX, float pDistanceY, MapView pMapView) {
        return false;
    }

    public void onShowPress(MotionEvent pEvent, MapView pMapView) {
    }

    public boolean onSingleTapUp(MotionEvent e, MapView mapView) {
        return false;
    }

    protected static synchronized void drawAt(Canvas canvas, Drawable drawable2, Point origin, Point offset, boolean shadow, float aMapOrientation) {
        canvas.save();
        canvas.rotate(-aMapOrientation, (float)origin.x, (float)origin.y);
        canvas.translate((float)(origin.x + offset.x), (float)(origin.y + offset.y));
        drawable2.draw(canvas);
        Paint paint = new Paint();
        paint.setColor(-65536);
        paint.setStrokeWidth(3.0f);
        canvas.drawLine(0.0f, -9.0f, 0.0f, 9.0f, paint);
        canvas.drawLine(-9.0f, 0.0f, 9.0f, 0.0f, paint);
        canvas.drawRect(drawable2.getBounds(), paint);
        canvas.restore();
    }

    public static interface Snappable {
        public boolean onSnapToItem(int var1, int var2, Point var3, MapView var4);
    }
}

