/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.overlay;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Environment;
import android.util.Log;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.overlay.Marker;
import com.mapbox.mapboxsdk.util.BitmapUtils;
import com.mapbox.mapboxsdk.util.MapboxUtils;
import com.mapbox.mapboxsdk.util.NetworkUtils;
import com.mapbox.mapboxsdk.util.constants.UtilConstants;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import uk.co.senab.bitmapcache.BitmapLruCache;
import uk.co.senab.bitmapcache.CacheableBitmapDrawable;

public class Icon
implements MapboxConstants {
    private Marker marker;
    private Drawable drawable;
    protected static BitmapLruCache sIconCache;
    private static final String DISK_CACHE_SUBDIR = "mapbox_icon_cache";
    private static ConcurrentHashMap<String, ArrayList<Icon>> downloadQueue;
    private static final String TAG = "Icon";

    protected BitmapLruCache getCache() {
        return this.getCache(null);
    }

    protected BitmapLruCache getCache(Context context) {
        if (sIconCache == null && context != null) {
            File cacheDir = Icon.getDiskCacheDir(context, DISK_CACHE_SUBDIR);
            if (!cacheDir.exists()) {
                if (cacheDir.mkdirs()) {
                    if (UtilConstants.DEBUGMODE) {
                        Log.d((String)TAG, (String)("creating cacheDir " + cacheDir));
                    }
                } else {
                    Log.e((String)TAG, (String)("can't create cacheDir " + cacheDir));
                }
            }
            sIconCache = new BitmapLruCache.Builder(context).setMemoryCacheEnabled(true).setMemoryCacheMaxSize(BitmapUtils.calculateMemoryCacheSize(context)).setDiskCacheEnabled(true).setDiskCacheMaxSize(0x100000L).build();
        }
        return sIconCache;
    }

    public static File getDiskCacheDir(Context context, String uniqueName) {
        String cachePath = "mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable() ? Environment.getExternalStorageDirectory().getPath() : context.getFilesDir().getPath();
        return new File(cachePath, uniqueName);
    }

    public Icon(Context context, Size size, String symbol, String aColor) {
        String url = MapboxUtils.markerIconURL(context, size.apiString, symbol, aColor);
        this.downloadBitmap(context, url);
    }

    public Icon(Drawable drawable2) {
        this.drawable = drawable2;
    }

    public Icon setMarker(Marker aMarker) {
        this.marker = aMarker;
        if (this.drawable != null) {
            this.marker.setMarker(this.drawable);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadBitmap(Context context, String url) {
        Log.d((String)TAG, (String)String.format("downloadBitmap() with url = '%s'", url));
        CacheableBitmapDrawable bitmap = this.getCache(context).getFromMemoryCache(url);
        if (bitmap != null) {
            this.drawable = bitmap;
            if (this.marker != null) {
                this.marker.setMarker(this.drawable);
            }
            return;
        }
        if (downloadQueue.putIfAbsent(url, new ArrayList()) == null) {
            ArrayList<Icon> list;
            ArrayList<Icon> arrayList = list = downloadQueue.get(url);
            synchronized (arrayList) {
                list.add(this);
                new BitmapLoader().execute(new String[]{url});
            }
        }
        ArrayList<Icon> list = downloadQueue.get(url);
        if (list == null) {
            this.drawable = sIconCache.get(url);
            if (this.marker != null) {
                this.marker.setMarker(this.drawable);
            }
            return;
        }
        ArrayList<Icon> arrayList = list;
        synchronized (arrayList) {
            if (list.isEmpty()) {
                this.drawable = sIconCache.get(url);
                if (this.marker != null) {
                    this.marker.setMarker(this.drawable);
                }
                return;
            }
            list.add(this);
        }
    }

    static {
        downloadQueue = new ConcurrentHashMap();
    }

    class BitmapLoader
    extends AsyncTask<String, Void, CacheableBitmapDrawable> {
        private String url;

        BitmapLoader() {
        }

        protected CacheableBitmapDrawable doInBackground(String ... src) {
            this.url = src[0];
            CacheableBitmapDrawable result = Icon.this.getCache().getFromDiskCache(this.url, null);
            if (result == null) {
                try {
                    if (UtilConstants.DEBUGMODE) {
                        Log.d((String)Icon.TAG, (String)("Maki url to load = '" + this.url + "'"));
                    }
                    HttpURLConnection connection = NetworkUtils.getHttpURLConnection(new URL(this.url));
                    result = sIconCache.put(this.url, connection.getInputStream());
                }
                catch (IOException e) {
                    Log.e((String)Icon.TAG, (String)("doInBackground: Unable to fetch icon from: " + this.url));
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onPostExecute(CacheableBitmapDrawable bitmap) {
            if (bitmap != null && Icon.this.marker != null) {
                ArrayList list;
                ArrayList arrayList = list = (ArrayList)downloadQueue.get(this.url);
                synchronized (arrayList) {
                    for (Icon icon : list) {
                        if (icon.marker == null) continue;
                        icon.marker.setMarker((Drawable)bitmap);
                    }
                    if (UtilConstants.DEBUGMODE) {
                        Log.d((String)Icon.TAG, (String)("Loaded:" + this.url));
                    }
                    downloadQueue.remove(this.url);
                }
            }
        }
    }

    public static enum Size {
        LARGE("l"),
        MEDIUM("m"),
        SMALL("s");

        private String apiString;

        private Size(String api) {
            this.apiString = api;
        }

        public String getApiString() {
            return this.apiString;
        }
    }
}

