/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.util;

import android.content.Context;
import android.graphics.Paint;
import android.text.TextUtils;
import android.util.Log;
import com.cocoahero.android.geojson.Feature;
import com.cocoahero.android.geojson.FeatureCollection;
import com.cocoahero.android.geojson.GeoJSON;
import com.cocoahero.android.geojson.LineString;
import com.cocoahero.android.geojson.MultiLineString;
import com.cocoahero.android.geojson.MultiPoint;
import com.cocoahero.android.geojson.MultiPolygon;
import com.cocoahero.android.geojson.Point;
import com.cocoahero.android.geojson.Polygon;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.overlay.Icon;
import com.mapbox.mapboxsdk.overlay.Marker;
import com.mapbox.mapboxsdk.overlay.PathOverlay;
import com.mapbox.mapboxsdk.util.NetworkUtils;
import com.mapbox.mapboxsdk.util.constants.UtilConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;

public class DataLoadingUtils {
    public static FeatureCollection loadGeoJSONFromUrl(String url) throws IOException, JSONException {
        if (TextUtils.isEmpty((CharSequence)url)) {
            throw new NullPointerException("No GeoJSON URL passed in.");
        }
        if (UtilConstants.DEBUGMODE) {
            Log.d((String)DataLoadingUtils.class.getCanonicalName(), (String)("Mapbox SDK downloading GeoJSON URL: " + url));
        }
        InputStream is = url.toLowerCase(Locale.US).indexOf("http") == 0 ? NetworkUtils.getHttpURLConnection(new URL(url)).getInputStream() : new URL(url).openStream();
        BufferedReader rd = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
        String jsonText = DataLoadingUtils.readAll(rd);
        FeatureCollection parsed = (FeatureCollection)GeoJSON.parse((String)jsonText);
        if (UtilConstants.DEBUGMODE) {
            Log.d((String)DataLoadingUtils.class.getCanonicalName(), (String)("Parsed GeoJSON with " + parsed.getFeatures().size() + " features."));
        }
        return parsed;
    }

    public static FeatureCollection loadGeoJSONFromAssets(Context context, String fileName) throws IOException, JSONException {
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            throw new NullPointerException("No GeoJSON File Name passed in.");
        }
        if (UtilConstants.DEBUGMODE) {
            Log.d((String)DataLoadingUtils.class.getCanonicalName(), (String)("Mapbox SDK loading GeoJSON URL: " + fileName));
        }
        InputStream is = context.getAssets().open(fileName);
        BufferedReader rd = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
        String jsonText = DataLoadingUtils.readAll(rd);
        FeatureCollection parsed = (FeatureCollection)GeoJSON.parse((String)jsonText);
        if (UtilConstants.DEBUGMODE) {
            Log.d((String)DataLoadingUtils.class.getCanonicalName(), (String)("Parsed GeoJSON with " + parsed.getFeatures().size() + " features."));
        }
        return parsed;
    }

    private static String readAll(Reader rd) throws IOException {
        int cp;
        StringBuilder sb = new StringBuilder();
        while ((cp = rd.read()) != -1) {
            sb.append((char)cp);
        }
        return sb.toString();
    }

    public static ArrayList<Object> createUIObjectsFromGeoJSONObjects(FeatureCollection featureCollection, Icon markerIcon) throws JSONException {
        ArrayList<Object> uiObjects = new ArrayList<Object>();
        for (Feature f : featureCollection.getFeatures()) {
            double lat;
            PathOverlay path;
            int j;
            if (f.getGeometry() instanceof Point) {
                JSONArray coordinates = (JSONArray)f.getGeometry().toJSON().get("coordinates");
                double lon = (Double)coordinates.get(0);
                double lat2 = (Double)coordinates.get(1);
                Marker marker = new Marker(f.getProperties().optString("title"), "", new LatLng(lat2, lon));
                if (markerIcon != null) {
                    marker.setIcon(markerIcon);
                }
                uiObjects.add(marker);
                continue;
            }
            if (f.getGeometry() instanceof MultiPoint) {
                JSONArray points = (JSONArray)f.getGeometry().toJSON().get("coordinates");
                for (j = 0; j < points.length(); ++j) {
                    JSONArray coordinates = (JSONArray)points.get(j);
                    double lon = (Double)coordinates.get(0);
                    double lat3 = (Double)coordinates.get(1);
                    Marker marker = new Marker(f.getProperties().optString("title"), "", new LatLng(lat3, lon));
                    if (markerIcon != null) {
                        marker.setIcon(markerIcon);
                    }
                    uiObjects.add(marker);
                }
                continue;
            }
            if (f.getGeometry() instanceof LineString) {
                path = new PathOverlay();
                JSONArray points = (JSONArray)f.getGeometry().toJSON().get("coordinates");
                for (j = 0; j < points.length(); ++j) {
                    JSONArray coordinates = (JSONArray)points.get(j);
                    double lon = (Double)coordinates.get(0);
                    double lat4 = (Double)coordinates.get(1);
                    path.addPoint(new LatLng(lat4, lon));
                }
                uiObjects.add(path);
                continue;
            }
            if (f.getGeometry() instanceof MultiLineString) {
                JSONArray lines = (JSONArray)f.getGeometry().toJSON().get("coordinates");
                for (int k = 0; k < lines.length(); ++k) {
                    PathOverlay path2 = new PathOverlay();
                    JSONArray points = (JSONArray)lines.get(k);
                    for (j = 0; j < points.length(); ++j) {
                        JSONArray coordinates = (JSONArray)points.get(j);
                        double lon = (Double)coordinates.get(0);
                        lat = (Double)coordinates.get(1);
                        path2.addPoint(new LatLng(lat, lon));
                    }
                    uiObjects.add(path2);
                }
                continue;
            }
            if (f.getGeometry() instanceof Polygon) {
                path = new PathOverlay();
                path.getPaint().setStyle(Paint.Style.FILL);
                JSONArray points = (JSONArray)f.getGeometry().toJSON().get("coordinates");
                for (int r = 0; r < points.length(); ++r) {
                    double lon;
                    JSONArray coordinates;
                    JSONArray ring = (JSONArray)points.get(r);
                    if (r == 0 && !DataLoadingUtils.windingOrder(ring) || r != 0 && DataLoadingUtils.windingOrder(ring)) {
                        for (j = 0; j < ring.length(); ++j) {
                            coordinates = (JSONArray)ring.get(j);
                            lon = (Double)coordinates.get(0);
                            lat = (Double)coordinates.get(1);
                            path.addPoint(new LatLng(lat, lon));
                        }
                    } else {
                        for (j = ring.length() - 1; j >= 0; --j) {
                            coordinates = (JSONArray)ring.get(j);
                            lon = (Double)coordinates.get(0);
                            lat = (Double)coordinates.get(1);
                            path.addPoint(new LatLng(lat, lon));
                        }
                    }
                    uiObjects.add(path);
                }
                continue;
            }
            if (!(f.getGeometry() instanceof MultiPolygon)) continue;
            path = new PathOverlay();
            path.getPaint().setStyle(Paint.Style.FILL);
            JSONArray polygons = (JSONArray)f.getGeometry().toJSON().get("coordinates");
            for (int p = 0; p < polygons.length(); ++p) {
                JSONArray points = (JSONArray)polygons.get(p);
                for (int r = 0; r < points.length(); ++r) {
                    double lat5;
                    double lon;
                    JSONArray coordinates;
                    JSONArray ring = (JSONArray)points.get(r);
                    if (r == 0 && !DataLoadingUtils.windingOrder(ring) || r != 0 && DataLoadingUtils.windingOrder(ring)) {
                        for (j = 0; j < ring.length(); ++j) {
                            coordinates = (JSONArray)ring.get(j);
                            lon = (Double)coordinates.get(0);
                            lat5 = (Double)coordinates.get(1);
                            path.addPoint(new LatLng(lat5, lon));
                        }
                    } else {
                        for (j = ring.length() - 1; j >= 0; --j) {
                            coordinates = (JSONArray)ring.get(j);
                            lon = (Double)coordinates.get(0);
                            lat5 = (Double)coordinates.get(1);
                            path.addPoint(new LatLng(lat5, lon));
                        }
                    }
                    uiObjects.add(path);
                }
            }
        }
        return uiObjects;
    }

    private static boolean windingOrder(JSONArray ring) throws JSONException {
        float area = 0.0f;
        if (ring.length() > 2) {
            for (int i = 0; i < ring.length() - 1; ++i) {
                JSONArray p1 = (JSONArray)ring.get(i);
                JSONArray p2 = (JSONArray)ring.get(i + 1);
                area = (float)((double)area + DataLoadingUtils.rad((Double)p2.get(0) - (Double)p1.get(0)) * (2.0 + Math.sin(DataLoadingUtils.rad((Double)p1.get(1))) + Math.sin(DataLoadingUtils.rad((Double)p2.get(1)))));
            }
        }
        return area > 0.0f;
    }

    private static double rad(double _) {
        return _ * Math.PI / 180.0;
    }
}

