/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.views.util;

import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import com.mapbox.mapboxsdk.api.ILatLng;
import com.mapbox.mapboxsdk.geometry.BoundingBox;
import com.mapbox.mapboxsdk.geometry.GeoConstants;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.util.GeometryMath;
import com.mapbox.mapboxsdk.views.MapView;

public class Projection
implements GeoConstants {
    private MapView mapView = null;
    private int viewWidth2;
    private int viewHeight2;
    private int worldSize2;
    private final int offsetX;
    private final int offsetY;
    private final int centerX;
    private final int centerY;
    private BoundingBox mBoundingBoxProjection;
    private final float mZoomLevelProjection;
    private final Rect mScreenRectProjection;
    private final Rect mIntrinsicScreenRectProjection;
    private final float mMapOrientation;
    private final Matrix mRotateMatrix = new Matrix();
    protected static int mTileSize = 256;
    private static final String TAG = "Projection";

    public Projection(MapView mv) {
        this.mapView = mv;
        this.viewWidth2 = this.mapView.getMeasuredWidth() >> 1;
        this.viewHeight2 = this.mapView.getMeasuredHeight() >> 1;
        this.mZoomLevelProjection = this.mapView.getZoomLevel(false);
        this.worldSize2 = Projection.mapSize(this.mZoomLevelProjection) >> 1;
        this.offsetX = -this.worldSize2;
        this.offsetY = -this.worldSize2;
        this.centerX = mv.getScrollX();
        this.centerY = mv.getScrollY();
        this.mIntrinsicScreenRectProjection = this.mapView.getIntrinsicScreenRect(null);
        this.mScreenRectProjection = this.mapView.getScreenRect(null);
        this.mMapOrientation = this.mapView.getMapOrientation();
        this.mRotateMatrix.setRotate(-this.mMapOrientation, (float)this.viewWidth2, (float)this.viewHeight2);
    }

    public float getZoomLevel() {
        return this.mZoomLevelProjection;
    }

    public int getHalfWorldSize() {
        return this.worldSize2;
    }

    public BoundingBox getBoundingBox() {
        if (this.mBoundingBoxProjection == null) {
            this.mBoundingBoxProjection = this.mapView.getBoundingBoxInternal();
        }
        return this.mBoundingBoxProjection;
    }

    public Rect getScreenRect() {
        return this.mScreenRectProjection;
    }

    public Rect getIntrinsicScreenRect() {
        return this.mIntrinsicScreenRectProjection;
    }

    public float getMapOrientation() {
        return this.mMapOrientation;
    }

    public int getCenterX() {
        return this.centerX;
    }

    public int getCenterY() {
        return this.centerY;
    }

    public ILatLng fromPixels(float x, float y) {
        Rect screenRect = this.getIntrinsicScreenRect();
        return Projection.pixelXYToLatLong(screenRect.left + (int)x + this.worldSize2, screenRect.top + (int)y + this.worldSize2, this.mZoomLevelProjection);
    }

    public ILatLng fromPixels(int x, int y) {
        return this.fromPixels((float)x, (float)y);
    }

    public Point fromMapPixels(int x, int y, Point reuse) {
        Point out = GeometryMath.reusable(reuse);
        out.set(x - this.viewWidth2, y - this.viewHeight2);
        out.offset(this.centerX, this.centerY);
        return out;
    }

    public PointF toPixels(ILatLng in, PointF reuse) {
        PointF result = this.toMapPixels(in, reuse);
        result.offset(-this.mIntrinsicScreenRectProjection.exactCenterX(), -this.mIntrinsicScreenRectProjection.exactCenterY());
        if (this.mMapOrientation % 360.0f != 0.0f) {
            GeometryMath.rotatePoint(0.0f, 0.0f, result, this.mMapOrientation, result);
        }
        result.offset((float)this.viewWidth2, (float)this.viewHeight2);
        return result;
    }

    public PointF toPixels(PointF mapPos, PointF reuse) {
        PointF out = GeometryMath.reusable(reuse);
        out.set(mapPos);
        out.offset((float)this.viewWidth2 - this.mIntrinsicScreenRectProjection.exactCenterX(), (float)this.viewHeight2 - this.mIntrinsicScreenRectProjection.exactCenterY());
        return out;
    }

    public PointF toMapPixels(ILatLng in, PointF reuse) {
        return this.toMapPixels(in.getLatitude(), in.getLongitude(), reuse);
    }

    public static PointF toMapPixels(double latitude, double longitude, float zoom, double centerX, double centerY, PointF reuse) {
        PointF out = GeometryMath.reusable(reuse);
        int mapSize = Projection.mapSize(zoom);
        Projection.latLongToPixelXY(latitude, longitude, zoom, out);
        float worldSize2 = mapSize >> 1;
        out.offset(-worldSize2, -worldSize2);
        return out;
    }

    public PointF toMapPixels(double latitude, double longitude, PointF reuse) {
        return Projection.toMapPixels(latitude, longitude, this.getZoomLevel(), this.centerX, this.centerY, reuse);
    }

    public static RectF toMapPixels(BoundingBox box, float zoom, RectF reuse) {
        RectF out = reuse != null ? reuse : new RectF();
        int mapSize_2 = Projection.mapSize(zoom) >> 1;
        PointF nw = Projection.latLongToPixelXY(box.getLatNorth(), box.getLonWest(), zoom, null);
        PointF se = Projection.latLongToPixelXY(box.getLatSouth(), box.getLonEast(), zoom, null);
        out.set(nw.x, nw.y, se.x, se.y);
        out.offset((float)(-mapSize_2), (float)(-mapSize_2));
        return out;
    }

    public static PointF toMapPixelsProjected(double latitude, double longitude, PointF reuse) {
        PointF out = reuse != null ? reuse : new PointF();
        Projection.latLongToPixelXY(latitude, longitude, 22.0f, out);
        return out;
    }

    public PointF toMapPixelsTranslated(PointF in, PointF reuse) {
        PointF out = reuse != null ? reuse : new PointF();
        float zoomDifference = 22.0f - this.getZoomLevel();
        out.set((float)((int)(GeometryMath.rightShift(in.x, zoomDifference) + (float)this.offsetX)), (float)((int)(GeometryMath.rightShift(in.y, zoomDifference) + (float)this.offsetY)));
        return out;
    }

    public Rect fromPixelsToProjected(Rect in) {
        Rect result = new Rect();
        float zoomDifference = 22.0f - this.getZoomLevel();
        int x0 = (int)GeometryMath.leftShift(in.left - this.offsetX, zoomDifference);
        int x1 = (int)GeometryMath.leftShift(in.right - this.offsetX, zoomDifference);
        int y0 = (int)GeometryMath.leftShift(in.bottom - this.offsetY, zoomDifference);
        int y1 = (int)GeometryMath.leftShift(in.top - this.offsetY, zoomDifference);
        result.set(Math.min(x0, x1), Math.min(y0, y1), Math.max(x0, x1), Math.max(y0, y1));
        return result;
    }

    public static void setTileSize(int tileSize) {
        mTileSize = tileSize;
    }

    public static int getTileSize() {
        return mTileSize;
    }

    private static double clip(double n, double minValue, double maxValue) {
        return Math.min(Math.max(n, minValue), maxValue);
    }

    public static int mapSize(float levelOfDetail) {
        return (int)GeometryMath.leftShift(mTileSize, levelOfDetail);
    }

    public static double groundResolution(double latitude, float levelOfDetail) {
        latitude = Projection.wrap(latitude, -90.0, 90.0, 180.0);
        latitude = Projection.clip(latitude, -85.05112878, 85.05112878);
        return Math.cos(latitude * Math.PI / 180.0) * 2.0 * Math.PI * 6378137.0 / (double)Projection.mapSize(levelOfDetail);
    }

    public static double mapScale(double latitude, int levelOfDetail, int screenDpi) {
        return Projection.groundResolution(latitude, levelOfDetail) * (double)screenDpi / 0.0254;
    }

    public static PointF latLongToPixelXY(double latitude, double longitude, float levelOfDetail, PointF reuse) {
        latitude = Projection.wrap(latitude, -90.0, 90.0, 180.0);
        longitude = Projection.wrap(longitude, -180.0, 180.0, 360.0);
        PointF out = reuse == null ? new PointF() : reuse;
        latitude = Projection.clip(latitude, -85.05112878, 85.05112878);
        longitude = Projection.clip(longitude, -180.0, 180.0);
        double x = (longitude + 180.0) / 360.0;
        double sinLatitude = Math.sin(latitude * Math.PI / 180.0);
        double y = 0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4);
        float mapSize = Projection.mapSize(levelOfDetail);
        out.x = (float)Projection.clip(x * (double)mapSize, 0.0, mapSize - 1.0f);
        out.y = (float)Projection.clip(y * (double)mapSize, 0.0, mapSize - 1.0f);
        return out;
    }

    public static LatLng pixelXYToLatLong(double pixelX, double pixelY, float levelOfDetail) {
        double mapSize = Projection.mapSize(levelOfDetail);
        double maxSize = mapSize - 1.0;
        double x = Projection.wrap(pixelX, 0.0, maxSize, mapSize);
        double y = Projection.wrap(pixelY, 0.0, maxSize, mapSize);
        x = Projection.clip(x, 0.0, maxSize) / mapSize - 0.5;
        y = 0.5 - Projection.clip(y, 0.0, maxSize) / mapSize;
        double latitude = 90.0 - 360.0 * Math.atan(Math.exp(-y * 2.0 * Math.PI)) / Math.PI;
        double longitude = 360.0 * x;
        return new LatLng(latitude, longitude);
    }

    public LatLng pixelXYToLatLong(double pixelX, double pixelY) {
        return Projection.pixelXYToLatLong(pixelX, pixelY, this.mZoomLevelProjection);
    }

    public static Point pixelXYToTileXY(int pixelX, int pixelY, Point reuse) {
        Point out = reuse == null ? new Point() : reuse;
        out.x = pixelX / mTileSize;
        out.y = pixelY / mTileSize;
        return out;
    }

    public static Point tileXYToPixelXY(int tileX, int tileY, Point reuse) {
        Point out = reuse == null ? new Point() : reuse;
        out.x = tileX * mTileSize;
        out.y = tileY * mTileSize;
        return out;
    }

    private static double wrap(double n, double minValue, double maxValue, double interval) {
        if (minValue > maxValue) {
            throw new IllegalArgumentException("minValue must be smaller than maxValue: " + minValue + ">" + maxValue);
        }
        if (interval > maxValue - minValue + 1.0) {
            throw new IllegalArgumentException("interval must be equal or smaller than maxValue-minValue: min: " + minValue + " max:" + maxValue + " int:" + interval);
        }
        while (n < minValue) {
            n += interval;
        }
        while (n > maxValue) {
            n -= interval;
        }
        return n;
    }

    public void rotatePoints(float[] pRotatePoints) {
        this.mRotateMatrix.mapPoints(pRotatePoints);
    }

    public void rotateRect(RectF rect) {
        this.mRotateMatrix.mapRect(rect);
    }

    public final Matrix getRotationMatrix() {
        return this.mRotateMatrix;
    }
}

