/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.views;

import android.view.GestureDetector;
import android.view.MotionEvent;
import com.mapbox.mapboxsdk.api.ILatLng;
import com.mapbox.mapboxsdk.util.constants.UtilConstants;
import com.mapbox.mapboxsdk.views.MapView;
import com.mapbox.mapboxsdk.views.util.Projection;

public class MapViewGestureDetectorListener
extends GestureDetector.SimpleOnGestureListener {
    private final MapView mapView;

    public MapViewGestureDetectorListener(MapView mv) {
        this.mapView = mv;
    }

    public boolean onDown(MotionEvent e) {
        if (this.mapView.mIsFlinging) {
            this.mapView.mScroller.abortAnimation();
            this.mapView.mIsFlinging = false;
        }
        if (this.mapView.getOverlayManager().onDown(e, this.mapView)) {
            return true;
        }
        return true;
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        if (this.mapView.isAnimating() || this.mapView.getOverlayManager().onFling(e1, e2, velocityX, velocityY, this.mapView)) {
            return true;
        }
        this.mapView.getProjection();
        int worldSize = Projection.mapSize(this.mapView.getZoomLevel(false));
        this.mapView.mIsFlinging = true;
        this.mapView.mScroller.fling(this.mapView.getScrollX(), this.mapView.getScrollY(), (int)(-velocityX), (int)(-velocityY), -worldSize, worldSize, -worldSize, worldSize);
        return true;
    }

    public void onLongPress(MotionEvent e) {
        if (this.mapView.getOverlayManager().onLongPress(e, this.mapView)) {
            return;
        }
        if (UtilConstants.DEBUGMODE) {
            ILatLng center = this.mapView.getProjection().fromPixels(e.getX(), e.getY());
            this.mapView.zoomOutFixing(center, true);
        }
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (this.mapView.isAnimating() || this.mapView.getOverlayManager().onScroll(e1, e2, distanceX, distanceY, this.mapView)) {
            return true;
        }
        this.mapView.getController().panBy((int)distanceX, (int)distanceY, true);
        return true;
    }

    public void onShowPress(MotionEvent e) {
        this.mapView.getOverlayManager().onShowPress(e, this.mapView);
    }

    public boolean onSingleTapUp(MotionEvent e) {
        return false;
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        return this.mapView.getOverlayManager().onSingleTapConfirmed(e, this.mapView);
    }

    public boolean onDoubleTap(MotionEvent e) {
        if (this.mapView.getOverlayManager().onDoubleTap(e, this.mapView)) {
            return true;
        }
        ILatLng center = this.mapView.getProjection().fromPixels(e.getX(), e.getY());
        return this.mapView.zoomInFixing(center, true);
    }
}

