/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.views;

import android.graphics.PointF;
import android.os.Handler;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.mapbox.mapboxsdk.api.ILatLng;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.views.MapView;
import com.mapbox.mapboxsdk.views.util.Projection;
import com.mapbox.mapboxsdk.views.util.constants.MapViewConstants;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorListenerAdapter;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.animation.PropertyValuesHolder;
import com.nineoldandroids.animation.TypeEvaluator;
import java.util.ArrayList;

public class MapController
implements MapViewConstants {
    private static final String TAG = "Mapbox MapController";
    protected final MapView mMapView;
    private ObjectAnimator mCurrentAnimation;
    private ILatLng zoomOnLatLong = null;
    private PointF zoomDeltaScroll = new PointF();
    private ILatLng animateToTargetPoint = null;
    private boolean mCurrentlyUserAction = false;
    private ILatLng mPointToGoTo = null;
    private float mZoomToZoomTo = -1.0f;

    public MapController(MapView mapView) {
        this.mMapView = mapView;
    }

    public boolean currentlyInUserAction() {
        return this.mCurrentlyUserAction;
    }

    public void setCurrentlyInUserAction(boolean value) {
        this.mCurrentlyUserAction = value;
    }

    protected void aboutToStartAnimation(ILatLng latlong, PointF mapCoords) {
        this.zoomOnLatLong = latlong;
        Projection projection = this.mMapView.getProjection();
        this.mMapView.mMultiTouchScalePoint.set(mapCoords.x, mapCoords.y);
        projection.toPixels(mapCoords, mapCoords);
        this.zoomDeltaScroll.set((float)((double)this.mMapView.getMeasuredWidth() / 2.0 - (double)mapCoords.x), (float)((double)this.mMapView.getMeasuredHeight() / 2.0 - (double)mapCoords.y));
    }

    protected void aboutToStartAnimation(ILatLng latlong) {
        PointF mapCoords = this.mMapView.getProjection().toMapPixels(latlong, null);
        this.aboutToStartAnimation(latlong, mapCoords);
    }

    protected void aboutToStartAnimation(PointF mapCoords) {
        float zoom = this.mMapView.getZoomLevel(false);
        this.mMapView.getProjection();
        double worldSize_2 = Projection.mapSize(zoom) >> 1;
        this.mMapView.getProjection();
        LatLng latlong = Projection.pixelXYToLatLong((double)mapCoords.x + worldSize_2, (double)mapCoords.y + worldSize_2, zoom);
        this.aboutToStartAnimation(latlong, mapCoords);
    }

    protected void aboutToStartAnimation(float screenX, float screenY) {
        float width_2 = (float)this.mMapView.getMeasuredWidth() / 2.0f;
        float height_2 = (float)this.mMapView.getMeasuredHeight() / 2.0f;
        PointF scrollPoint = this.mMapView.getScrollPoint();
        double mapX = screenX + scrollPoint.x - width_2;
        double mapY = screenY + scrollPoint.y - height_2;
        float zoom = this.mMapView.getZoomLevel(false);
        this.mMapView.getProjection();
        double worldSize_2 = Projection.mapSize(zoom) >> 1;
        this.mMapView.getProjection();
        this.zoomOnLatLong = Projection.pixelXYToLatLong(mapX + worldSize_2, mapY + worldSize_2, zoom);
        this.mMapView.mMultiTouchScalePoint.set((float)mapX, (float)mapY);
        this.zoomDeltaScroll.set(width_2 - screenX, height_2 - screenY);
    }

    public void animateTo(ILatLng point, boolean userAction) {
        this.setZoomAnimated(point, this.mMapView.getZoomLevel(), true, userAction);
    }

    public void animateTo(ILatLng point) {
        this.animateTo(point, false);
    }

    public void goTo(ILatLng point, PointF delta) {
        Projection projection = this.mMapView.getProjection();
        PointF p = projection.toMapPixels(point, null);
        p.offset(delta.x, delta.y);
        this.mMapView.scrollTo(p.x, p.y);
    }

    public void panBy(float x, float y, boolean userAction) {
        this.mCurrentlyUserAction = userAction;
        this.mMapView.scrollBy(x, y);
        this.mCurrentlyUserAction = false;
    }

    public void offsetDeltaScroll(float x, float y) {
        this.zoomDeltaScroll.offset(x, y);
    }

    public void panBy(int x, int y) {
        this.panBy(x, y, false);
    }

    public void setCenter(ILatLng latlng) {
        this.setCenter(latlng, null);
    }

    public void setCenter(ILatLng latlng, PointF decale) {
        if (latlng == null) {
            return;
        }
        if (!this.mMapView.isLayedOut()) {
            this.mPointToGoTo = latlng;
            return;
        }
        PointF p = this.mMapView.getProjection().toMapPixels(latlng, null);
        if (decale != null) {
            p.offset(decale.x, decale.y);
        }
        this.mMapView.scrollTo(p.x, p.y);
    }

    public void stopPanning() {
        this.mMapView.mIsFlinging = false;
        this.mMapView.getScroller().forceFinished(true);
    }

    public void stopAnimation(boolean jumpToTarget) {
        if (!this.mMapView.getScroller().isFinished()) {
            if (jumpToTarget) {
                this.mMapView.mIsFlinging = false;
                this.mMapView.getScroller().abortAnimation();
                this.setCenter(this.animateToTargetPoint);
            } else {
                this.stopPanning();
            }
        }
        if (this.mMapView.mIsAnimating.get()) {
            this.mCurrentAnimation.cancel();
            this.mMapView.setZoomInternal(Float.intBitsToFloat(this.mMapView.mTargetZoomLevel.get()));
            if (jumpToTarget && this.zoomOnLatLong != null) {
                this.goTo(this.zoomOnLatLong, this.zoomDeltaScroll);
            }
            this.mMapView.mIsAnimating.set(false);
        }
    }

    public boolean setZoomAnimated(ILatLng latlong, float zoomlevel, boolean move, boolean userAction) {
        boolean zoomAndMove;
        if (userAction && this.mMapView.isAnimating()) {
            return false;
        }
        if (!this.mMapView.isLayedOut()) {
            this.mPointToGoTo = latlong;
            this.mZoomToZoomTo = zoomlevel;
            return false;
        }
        this.stopAnimation(true);
        this.mCurrentlyUserAction = userAction;
        this.mMapView.mIsFlinging = false;
        float currentZoom = this.mMapView.getZoomLevel(false);
        PointF dCurrentScroll = this.mMapView.getScrollPoint();
        PointF p = Projection.toMapPixels(latlong.getLatitude(), latlong.getLongitude(), currentZoom, dCurrentScroll.x, dCurrentScroll.y, null);
        this.mMapView.mMultiTouchScalePoint.set(p.x, p.y);
        ArrayList<PropertyValuesHolder> propertiesList = new ArrayList<PropertyValuesHolder>();
        float targetZoom = this.mMapView.getClampedZoomLevel(zoomlevel);
        boolean zoomAnimating = targetZoom != currentZoom;
        this.zoomDeltaScroll.set(0.0f, 0.0f);
        if (zoomAnimating) {
            this.zoomOnLatLong = latlong;
            this.mMapView.mTargetZoomLevel.set(Float.floatToIntBits(targetZoom));
            float factor = (float)Math.pow(2.0, targetZoom - currentZoom);
            float delta = targetZoom - currentZoom;
            if (delta > 0.0f) {
                propertiesList.add(PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{1.0f, factor}));
            } else {
                propertiesList.add(PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{1.0f, factor}));
            }
        }
        boolean bl = zoomAndMove = move && !p.equals((Object)dCurrentScroll);
        if (zoomAndMove) {
            PointEvaluator evaluator = new PointEvaluator();
            propertiesList.add(PropertyValuesHolder.ofObject((String)"scrollPoint", (TypeEvaluator)evaluator, (Object[])new Object[]{p}));
        } else {
            this.mMapView.getProjection().toPixels(p, p);
            this.zoomDeltaScroll.set((float)((double)this.mMapView.getMeasuredWidth() / 2.0 - (double)p.x), (float)((double)this.mMapView.getMeasuredHeight() / 2.0 - (double)p.y));
        }
        if (propertiesList.size() > 0) {
            ObjectAnimator anim = ObjectAnimator.ofPropertyValuesHolder((Object)this, (PropertyValuesHolder[])propertiesList.toArray(new PropertyValuesHolder[0]));
            anim.setInterpolator((Interpolator)new LinearInterpolator());
            anim.setDuration(zoomAndMove ? 500L : 250L);
            anim.setTarget((Object)this.mMapView);
            anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    MapController.this.onAnimationStart();
                    super.onAnimationStart(animation);
                }

                public void onAnimationEnd(Animator animation) {
                    MapController.this.onAnimationEnd();
                    super.onAnimationEnd(animation);
                }
            });
            this.mCurrentAnimation = anim;
            anim.start();
            return true;
        }
        return false;
    }

    public MapView setZoom(float zoomlevel) {
        return this.setZoom(zoomlevel, false);
    }

    public MapView setZoom(float zoomlevel, boolean userAction) {
        this.mCurrentlyUserAction = userAction;
        this.stopAnimation(true);
        this.mMapView.setZoomInternal(zoomlevel);
        this.mCurrentlyUserAction = false;
        return this.mMapView;
    }

    public MapView setZoomAnimated(float zoomlevel) {
        this.setZoomAnimated(zoomlevel, this.mMapView.getCenter(), false);
        return this.mMapView;
    }

    public MapView setZoomAnimated(float zoomlevel, ILatLng latlong, boolean userAction) {
        this.setZoomAnimated(latlong, zoomlevel, false, userAction);
        return this.mMapView;
    }

    public boolean zoomIn(boolean userAction) {
        return this.zoomInAbout(this.mMapView.getCenter(), userAction);
    }

    public boolean zoomIn() {
        return this.zoomIn(false);
    }

    public boolean zoomInAbout(ILatLng latlong, boolean userAction) {
        float currentZoom = this.mMapView.getZoomLevel(false);
        float targetZoom = (float)(Math.ceil(currentZoom) + 1.0);
        float factor = (float)Math.pow(2.0, targetZoom - currentZoom);
        if ((double)factor > 2.25) {
            targetZoom = (float)Math.ceil(currentZoom);
        }
        return this.setZoomAnimated(latlong, targetZoom, false, userAction);
    }

    public boolean zoomInAbout(ILatLng latlong) {
        return this.zoomInAbout(latlong, false);
    }

    public boolean zoomOut(boolean userAction) {
        return this.zoomOutAbout(this.mMapView.getCenter(), userAction);
    }

    public boolean zoomOut() {
        return this.zoomOut(false);
    }

    public boolean zoomOutAbout(ILatLng latlong, boolean userAction) {
        float currentZoom = this.mMapView.getZoomLevel(false);
        float targetZoom = (float)Math.floor(currentZoom);
        float factor = (float)Math.pow(2.0, targetZoom - currentZoom);
        if ((double)factor > 0.75) {
            targetZoom = (float)(Math.floor(currentZoom) - 1.0);
        }
        return this.setZoomAnimated(latlong, targetZoom, false, userAction);
    }

    public boolean zoomOutAbout(ILatLng latlong) {
        return this.zoomOutAbout(latlong, false);
    }

    protected void onAnimationStart() {
        this.mMapView.mIsAnimating.set(true);
    }

    public void onAnimationEnd() {
        this.stopPanning();
        this.mMapView.setZoomInternal(Float.intBitsToFloat(this.mMapView.mTargetZoomLevel.get()), this.zoomOnLatLong, this.zoomDeltaScroll);
        this.zoomOnLatLong = null;
        this.mCurrentlyUserAction = false;
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                MapController.this.mMapView.mIsAnimating.set(false);
            }
        }, 100L);
    }

    public void mapViewLayedOut() {
        if (this.mPointToGoTo != null) {
            this.setCenter(this.mPointToGoTo);
            this.mPointToGoTo = null;
        }
        if (this.mZoomToZoomTo != -1.0f) {
            this.setZoom(this.mZoomToZoomTo);
            this.mZoomToZoomTo = -1.0f;
        }
    }

    public class PointEvaluator
    implements TypeEvaluator<PointF> {
        public PointF evaluate(float fraction, PointF startValue, PointF endValue) {
            return new PointF(fraction * (endValue.x - startValue.x) + startValue.x, fraction * (endValue.y - startValue.y) + startValue.y);
        }
    }
}

