/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.views;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.overlay.Marker;
import com.mapbox.mapboxsdk.views.MapView;

public class InfoWindow {
    private Marker boundMarker;
    private MapView mMapView;
    private boolean mIsVisible;
    private View mView;
    static int mTitleId = 0;
    static int mDescriptionId = 0;
    static int mSubDescriptionId = 0;
    static int mImageId = 0;

    public InfoWindow(int layoutResId, MapView mapView) {
        this.mMapView = mapView;
        this.mIsVisible = false;
        ViewGroup parent = (ViewGroup)mapView.getParent();
        Context context = mapView.getContext();
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mView = inflater.inflate(layoutResId, parent, false);
        if (mTitleId == 0) {
            InfoWindow.setResIds(mapView.getContext());
        }
        this.mView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent e) {
                if (e.getAction() == 1) {
                    InfoWindow.this.close();
                }
                return true;
            }
        });
    }

    public InfoWindow(View view, MapView mapView) {
        this.mMapView = mapView;
        this.mIsVisible = false;
        ViewGroup parent = (ViewGroup)mapView.getParent();
        Context context = mapView.getContext();
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mView = view;
        this.mView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent e) {
                if (e.getAction() == 1) {
                    InfoWindow.this.close();
                }
                return true;
            }
        });
    }

    public InfoWindow open(Marker object, LatLng position, int offsetX, int offsetY) {
        this.onOpen(object);
        MapView.LayoutParams lp = new MapView.LayoutParams(-2, -2, position, 8, offsetX, offsetY);
        this.close();
        this.mMapView.addView(this.mView, lp);
        this.mIsVisible = true;
        return this;
    }

    public InfoWindow close() {
        if (this.mIsVisible) {
            this.mIsVisible = false;
            ((ViewGroup)this.mView.getParent()).removeView(this.mView);
            this.boundMarker.blur();
            this.setBoundMarker(null);
            this.onClose();
        }
        return this;
    }

    public View getView() {
        return this.mView;
    }

    public MapView getMapView() {
        return this.mMapView;
    }

    public void onOpen(Marker overlayItem) {
        String title = overlayItem.getTitle();
        ((TextView)this.mView.findViewById(mTitleId)).setText((CharSequence)title);
        String snippet = overlayItem.getDescription();
        ((TextView)this.mView.findViewById(mDescriptionId)).setText((CharSequence)snippet);
        TextView subDescText = (TextView)this.mView.findViewById(mSubDescriptionId);
        String subDesc = overlayItem.getSubDescription();
        if ("".equals(subDesc)) {
            subDescText.setVisibility(8);
        } else {
            subDescText.setText((CharSequence)subDesc);
            subDescText.setVisibility(0);
        }
    }

    public void onClose() {
    }

    public InfoWindow setBoundMarker(Marker aBoundMarker) {
        this.boundMarker = aBoundMarker;
        return this;
    }

    public Marker getBoundMarker() {
        return this.boundMarker;
    }

    private static void setResIds(Context context) {
        String packageName = context.getPackageName();
        mTitleId = context.getResources().getIdentifier("id/tooltip_title", null, packageName);
        mDescriptionId = context.getResources().getIdentifier("id/tooltip_description", null, packageName);
        mSubDescriptionId = context.getResources().getIdentifier("id/tooltip_subdescription", null, packageName);
        mImageId = context.getResources().getIdentifier("id/tooltip_image", null, packageName);
    }
}

