/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.tileprovider.tilesource;

import com.mapbox.mapboxsdk.tileprovider.MapTile;
import com.mapbox.mapboxsdk.tileprovider.tilesource.TileLayer;
import com.mapbox.mapboxsdk.tileprovider.tilesource.WebSourceTileLayer;

public class TileMillLayer
extends WebSourceTileLayer {
    private static final String BASE_URL = "http://%s:20008/tile/%s";

    public TileMillLayer(String pHost, String pMap, float pMinZoom, float pMaxZoom) {
        super(pHost, String.format(BASE_URL, pHost, pMap));
        this.mName = "TileMill";
        this.mMinimumZoomLevel = pMinZoom;
        this.mMaximumZoomLevel = pMaxZoom;
    }

    public TileMillLayer(String pHost, String pMap) {
        this(pHost, pMap, 0.0f, 22.0f);
    }

    public TileMillLayer(String pMap) {
        this("localhost", pMap);
    }

    @Override
    public TileLayer setURL(String aUrl) {
        super.setURL(aUrl + "/%d/%d/%d.png?updated=%d");
        return this;
    }

    @Override
    public String getTileURL(MapTile aTile, boolean hdpi) {
        return String.format(this.mUrl, aTile.getZ(), aTile.getX(), aTile.getY(), System.currentTimeMillis() / 1000L);
    }
}

