/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.overlay;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;
import com.mapbox.mapboxsdk.overlay.SafeDrawOverlay;
import com.mapbox.mapboxsdk.tileprovider.MapTile;
import com.mapbox.mapboxsdk.tileprovider.MapTileLayerBase;
import com.mapbox.mapboxsdk.util.GeometryMath;
import com.mapbox.mapboxsdk.util.TileLooper;
import com.mapbox.mapboxsdk.util.constants.UtilConstants;
import com.mapbox.mapboxsdk.views.MapView;
import com.mapbox.mapboxsdk.views.safecanvas.ISafeCanvas;
import com.mapbox.mapboxsdk.views.safecanvas.SafePaint;
import com.mapbox.mapboxsdk.views.util.Projection;
import java.util.HashMap;
import uk.co.senab.bitmapcache.CacheableBitmapDrawable;

public class TilesOverlay
extends SafeDrawOverlay {
    public static final int MENU_OFFLINE = TilesOverlay.getSafeMenuId();
    protected final MapTileLayerBase mTileProvider;
    protected static SafePaint mDebugPaint = null;
    protected static SafePaint mLoadingTilePaint = null;
    protected static Bitmap mLoadingTileBitmap = null;
    protected Paint mLoadingPaint = null;
    private final Rect mTileRect = new Rect();
    private final Rect mViewPort = new Rect();
    private final Rect mClipRect = new Rect();
    float mCurrentZoomFactor = 1.0f;
    private boolean mOptionsMenuEnabled = true;
    private int mWorldSize_2;
    private int mLoadingBackgroundColor = Color.rgb((int)216, (int)208, (int)208);
    private int mLoadingLineColor = Color.rgb((int)200, (int)192, (int)192);
    private final TileLooper mTileLooper = new TileLooper(){

        @Override
        public void initializeLoop(float pZoomLevel, int pTileSizePx) {
            int roundedZoom = (int)Math.floor(pZoomLevel);
            if ((float)roundedZoom != pZoomLevel) {
                int mapTileUpperBound = 1 << roundedZoom;
                TilesOverlay.this.mCurrentZoomFactor = (float)Projection.mapSize(pZoomLevel) / (float)mapTileUpperBound / (float)pTileSizePx;
            } else {
                TilesOverlay.this.mCurrentZoomFactor = 1.0f;
            }
        }

        @Override
        public void handleTile(Canvas pCanvas, String pCacheKey, int pTileSizePx, MapTile pTile, int pX, int pY, Rect pClipRect) {
            double factor = (float)pTileSizePx * TilesOverlay.this.mCurrentZoomFactor;
            double x = (double)pX * factor - (double)TilesOverlay.this.mWorldSize_2;
            double y = (double)pY * factor - (double)TilesOverlay.this.mWorldSize_2;
            TilesOverlay.this.mTileRect.set((int)x, (int)y, (int)(x + factor), (int)(y + factor));
            if (!Rect.intersects((Rect)TilesOverlay.this.mTileRect, (Rect)pClipRect)) {
                return;
            }
            pTile.setTileRect(TilesOverlay.this.mTileRect);
            Drawable drawable2 = TilesOverlay.this.mTileProvider.getMapTile(pTile);
            boolean isReusable = drawable2 instanceof CacheableBitmapDrawable;
            if (drawable2 != null) {
                if (isReusable) {
                    this.mBeingUsedDrawables.add((CacheableBitmapDrawable)drawable2);
                }
                drawable2.setBounds(TilesOverlay.this.mTileRect);
                drawable2.draw(pCanvas);
                if (UtilConstants.DEBUGMODE) {
                    ISafeCanvas canvas = (ISafeCanvas)pCanvas;
                    canvas.drawText(pTile.toString(), ((TilesOverlay)TilesOverlay.this).mTileRect.left + 1, (float)((TilesOverlay)TilesOverlay.this).mTileRect.top + mDebugPaint.getTextSize(), mDebugPaint);
                    canvas.drawRect(TilesOverlay.this.mTileRect, mDebugPaint);
                }
            }
        }
    };
    private static final String TAG = "TilesOverlay";

    public TilesOverlay(MapTileLayerBase aTileProvider) {
        if (aTileProvider == null) {
            throw new IllegalArgumentException("You must pass a valid tile provider to the tiles overlay.");
        }
        this.mTileProvider = aTileProvider;
        if (UtilConstants.DEBUGMODE && mDebugPaint == null) {
            mDebugPaint = new SafePaint();
            mDebugPaint.setAntiAlias(true);
            mDebugPaint.setFilterBitmap(true);
            mDebugPaint.setColor(-65536);
            mDebugPaint.setStyle(Paint.Style.STROKE);
        }
        this.mLoadingPaint = new Paint();
        this.mLoadingPaint.setAntiAlias(true);
        this.mLoadingPaint.setFilterBitmap(true);
        this.mLoadingPaint.setColor(this.mLoadingLineColor);
        this.mLoadingPaint.setStrokeWidth(0.0f);
    }

    @Override
    public void onDetach(MapView pMapView) {
        this.mTileProvider.detach();
    }

    public float getMinimumZoomLevel() {
        return this.mTileProvider.getMinimumZoomLevel();
    }

    public float getMaximumZoomLevel() {
        return this.mTileProvider.getMaximumZoomLevel();
    }

    public boolean useDataConnection() {
        return this.mTileProvider.useDataConnection();
    }

    public void setUseDataConnection(boolean aMode) {
        this.mTileProvider.setUseDataConnection(aMode);
    }

    @Override
    protected void drawSafe(ISafeCanvas c, MapView mapView, boolean shadow) {
        if (shadow) {
            return;
        }
        Projection pj = mapView.getProjection();
        c.getClipBounds(this.mClipRect);
        float zoomLevel = pj.getZoomLevel();
        this.mWorldSize_2 = pj.getHalfWorldSize();
        GeometryMath.viewPortRectForTileDrawing(pj, this.mViewPort);
        int tileSize = Projection.getTileSize();
        if (tileSize > 0) {
            this.drawLoadingTile(c.getSafeCanvas(), mapView, zoomLevel, this.mClipRect);
            this.drawTiles(c.getSafeCanvas(), zoomLevel, tileSize, this.mViewPort, this.mClipRect);
        }
    }

    public void drawLoadingTile(Canvas c, MapView mapView, float zoomLevel, Rect viewPort) {
        float mapScale = mapView.getScale();
        ISafeCanvas canvas = (ISafeCanvas)c;
        canvas.save();
        canvas.scale(mapScale, mapScale, viewPort.exactCenterX(), viewPort.exactCenterY());
        canvas.translate(-mapView.getScrollX(), -mapView.getScrollY());
        canvas.drawPaint(this.getLoadingTilePaint());
        canvas.restore();
    }

    public void drawTiles(Canvas c, float zoomLevel, int tileSizePx, Rect viewPort, Rect pClipRect) {
        this.mTileLooper.loop(c, this.mTileProvider.getCacheKey(), zoomLevel, tileSizePx, viewPort, pClipRect);
        if (UtilConstants.DEBUGMODE) {
            ISafeCanvas canvas = (ISafeCanvas)c;
            Point centerPoint = new Point(viewPort.centerX() - this.mWorldSize_2, viewPort.centerY() - this.mWorldSize_2);
            canvas.drawLine(centerPoint.x, centerPoint.y - 9, centerPoint.x, centerPoint.y + 9, mDebugPaint);
            canvas.drawLine(centerPoint.x - 9, centerPoint.y, centerPoint.x + 9, centerPoint.y, mDebugPaint);
        }
    }

    public int getLoadingBackgroundColor() {
        return this.mLoadingBackgroundColor;
    }

    public void setLoadingBackgroundColor(int pLoadingBackgroundColor) {
        if (this.mLoadingBackgroundColor != pLoadingBackgroundColor) {
            this.mLoadingBackgroundColor = pLoadingBackgroundColor;
            this.clearLoadingTile();
        }
    }

    public int getLoadingLineColor() {
        return this.mLoadingLineColor;
    }

    public void setLoadingLineColor(int pLoadingLineColor) {
        if (this.mLoadingLineColor != pLoadingLineColor) {
            this.mLoadingLineColor = pLoadingLineColor;
            this.mLoadingPaint.setColor(this.mLoadingLineColor);
            this.clearLoadingTile();
        }
    }

    private SafePaint getLoadingTilePaint() {
        if (mLoadingTilePaint == null && this.mLoadingBackgroundColor != 0) {
            try {
                int tileSize = this.mTileProvider.getTileSource() != null ? this.mTileProvider.getTileSource().getTileSizePixels() : 256;
                mLoadingTileBitmap = Bitmap.createBitmap((int)tileSize, (int)tileSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(mLoadingTileBitmap);
                canvas.drawColor(this.mLoadingBackgroundColor);
                int lineSize = tileSize / 16;
                for (int a = 0; a < tileSize; a += lineSize) {
                    canvas.drawLine(0.0f, (float)a, (float)tileSize, (float)a, this.mLoadingPaint);
                    canvas.drawLine((float)a, 0.0f, (float)a, (float)tileSize, this.mLoadingPaint);
                }
                mLoadingTilePaint = new SafePaint();
                mLoadingTilePaint.setShader((Shader)new BitmapShader(mLoadingTileBitmap, Shader.TileMode.REPEAT, Shader.TileMode.REPEAT));
            }
            catch (OutOfMemoryError e) {
                Log.e((String)TAG, (String)"OutOfMemoryError getting loading tile");
                System.gc();
            }
        }
        return mLoadingTilePaint;
    }

    private void clearLoadingTile() {
        mLoadingTilePaint = null;
        if (Build.VERSION.SDK_INT < 9 && mLoadingTileBitmap != null) {
            mLoadingTileBitmap.recycle();
            mLoadingTileBitmap = null;
        }
    }

    public void rescaleCache(float pNewZoomLevel, float pOldZoomLevel, Projection projection) {
        if (this.mTileProvider.hasNoSource() || Math.floor(pNewZoomLevel) == Math.floor(pOldZoomLevel) || projection == null) {
            return;
        }
        long startMs = System.currentTimeMillis();
        if (UtilConstants.DEBUGMODE) {
            Log.d((String)TAG, (String)("rescale tile cache from " + pOldZoomLevel + " to " + pNewZoomLevel));
        }
        int tileSize = Projection.getTileSize();
        Rect viewPort = GeometryMath.viewPortRectForTileDrawing(pNewZoomLevel, projection, null);
        ScaleTileLooper tileLooper = pNewZoomLevel > pOldZoomLevel ? new ZoomInTileLooper(pOldZoomLevel) : new ZoomOutTileLooper(pOldZoomLevel);
        tileLooper.loop(null, this.mTileProvider.getCacheKey(), pNewZoomLevel, tileSize, viewPort, null);
        long endMs = System.currentTimeMillis();
        if (UtilConstants.DEBUGMODE) {
            Log.d((String)TAG, (String)("Finished rescale in " + (endMs - startMs) + "ms"));
        }
    }

    private class ZoomOutTileLooper
    extends ScaleTileLooper {
        private static final int MAX_ZOOM_OUT_DIFF = 8;

        public ZoomOutTileLooper(float pOldZoomLevel) {
            super(pOldZoomLevel);
        }

        @Override
        protected void handleScaleTile(String pCacheKey, int pTileSizePx, MapTile pTile, int pX, int pY) {
            if (this.mDiff >= 8.0f) {
                return;
            }
            int xx = (int)GeometryMath.leftShift(pX, this.mDiff);
            int yy = (int)GeometryMath.leftShift(pY, this.mDiff);
            int numTiles = (int)GeometryMath.leftShift(1.0f, this.mDiff);
            Bitmap bitmap = null;
            Canvas canvas = null;
            for (int x = 0; x < numTiles; ++x) {
                for (int y = 0; y < numTiles; ++y) {
                    Bitmap oldBitmap;
                    int oldTileY = GeometryMath.mod(yy + y, this.mOldTileUpperBound);
                    int oldTileX = GeometryMath.mod(xx + x, this.mOldTileUpperBound);
                    MapTile oldTile = new MapTile(pCacheKey, this.mOldZoomRound, oldTileX, oldTileY);
                    CacheableBitmapDrawable oldDrawable = TilesOverlay.this.mTileProvider.getMapTileFromMemory(oldTile);
                    if (!(oldDrawable instanceof BitmapDrawable)) continue;
                    if (oldDrawable instanceof CacheableBitmapDrawable) {
                        oldDrawable.setBeingUsed(true);
                        this.mBeingUsedDrawables.add(oldDrawable);
                    }
                    if ((oldBitmap = ((BitmapDrawable)oldDrawable).getBitmap()) == null) continue;
                    if (bitmap == null) {
                        bitmap = TilesOverlay.this.mTileProvider.getBitmapFromRemoved(pTileSizePx, pTileSizePx);
                        if (bitmap == null) {
                            bitmap = Bitmap.createBitmap((int)pTileSizePx, (int)pTileSizePx, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        }
                        canvas = new Canvas(bitmap);
                    }
                    this.mDestRect.set(x * this.mTileSize_2, y * this.mTileSize_2, (x + 1) * this.mTileSize_2, (y + 1) * this.mTileSize_2);
                    canvas.drawBitmap(oldBitmap, null, this.mDestRect, null);
                    TilesOverlay.this.mTileProvider.removeTileFromMemory(oldTile);
                }
            }
            if (bitmap != null) {
                this.mNewTiles.put(pTile, bitmap);
            }
        }
    }

    private class ZoomInTileLooper
    extends ScaleTileLooper {
        public ZoomInTileLooper(float pOldZoomLevel) {
            super(pOldZoomLevel);
        }

        @Override
        public void handleScaleTile(String pCacheKey, int pTileSizePx, MapTile pTile, int pX, int pY) {
            int oldTileY;
            int oldTileX = GeometryMath.mod((int)GeometryMath.rightShift(pX, this.mDiff), this.mOldTileUpperBound);
            MapTile oldTile = new MapTile(pCacheKey, this.mOldZoomRound, oldTileX, oldTileY = GeometryMath.mod((int)GeometryMath.rightShift(pY, this.mDiff), this.mOldTileUpperBound));
            CacheableBitmapDrawable oldDrawable = TilesOverlay.this.mTileProvider.getMapTileFromMemory(oldTile);
            if (oldDrawable instanceof BitmapDrawable) {
                if (oldDrawable instanceof CacheableBitmapDrawable) {
                    oldDrawable.setBeingUsed(true);
                    this.mBeingUsedDrawables.add(oldDrawable);
                }
                int xx = pX % (int)GeometryMath.leftShift(1.0f, this.mDiff) * this.mTileSize_2;
                int yy = pY % (int)GeometryMath.leftShift(1.0f, this.mDiff) * this.mTileSize_2;
                this.mSrcRect.set(xx, yy, xx + this.mTileSize_2, yy + this.mTileSize_2);
                this.mDestRect.set(0, 0, pTileSizePx, pTileSizePx);
                Bitmap bitmap = TilesOverlay.this.mTileProvider.getBitmapFromRemoved(pTileSizePx, pTileSizePx);
                if (bitmap == null) {
                    bitmap = Bitmap.createBitmap((int)pTileSizePx, (int)pTileSizePx, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                }
                Canvas canvas = new Canvas(bitmap);
                boolean isReusable = oldDrawable instanceof CacheableBitmapDrawable;
                boolean success = false;
                if (!isReusable || oldDrawable.isBitmapValid()) {
                    Bitmap oldBitmap = ((BitmapDrawable)oldDrawable).getBitmap();
                    canvas.drawBitmap(oldBitmap, this.mSrcRect, this.mDestRect, null);
                    success = true;
                }
                if (success) {
                    this.mNewTiles.put(pTile, bitmap);
                }
            }
        }
    }

    private abstract class ScaleTileLooper
    extends TileLooper {
        protected final HashMap<MapTile, Bitmap> mNewTiles;
        protected final float mOldZoomLevel;
        protected final int mOldZoomRound;
        protected final int mOldTileUpperBound;
        protected float mDiff;
        protected int mTileSize_2;
        protected Rect mSrcRect;
        protected Rect mDestRect;
        protected Paint mDebugPaint;

        public ScaleTileLooper(float pOldZoomLevel) {
            this.mOldZoomLevel = pOldZoomLevel;
            this.mOldZoomRound = (int)Math.floor(this.mOldZoomLevel);
            this.mOldTileUpperBound = 1 << this.mOldZoomRound;
            this.mNewTiles = new HashMap();
            this.mSrcRect = new Rect();
            this.mDestRect = new Rect();
            this.mDebugPaint = new Paint();
        }

        @Override
        public void initializeLoop(float pZoomLevel, int pTileSizePx) {
            this.mDiff = (float)Math.abs(Math.floor(pZoomLevel) - Math.floor(this.mOldZoomLevel));
            this.mTileSize_2 = (int)GeometryMath.rightShift(pTileSizePx, this.mDiff);
        }

        @Override
        public void handleTile(Canvas pCanvas, String pCacheKey, int pTileSizePx, MapTile pTile, int pX, int pY, Rect pClipRect) {
            Drawable requestedTile = TilesOverlay.this.mTileProvider.getMapTile(pTile);
            if (requestedTile == null) {
                try {
                    this.handleScaleTile(pCacheKey, pTileSizePx, pTile, pX, pY);
                }
                catch (OutOfMemoryError e) {
                    Log.e((String)TilesOverlay.TAG, (String)"OutOfMemoryError rescaling cache");
                }
            }
        }

        @Override
        public void finalizeLoop() {
            super.finalizeLoop();
            while (!this.mNewTiles.isEmpty()) {
                MapTile tile = this.mNewTiles.keySet().iterator().next();
                Bitmap bitmap = this.mNewTiles.remove(tile);
                TilesOverlay.this.mTileProvider.putExpiredTileIntoCache(tile, bitmap);
            }
        }

        protected abstract void handleScaleTile(String var1, int var2, MapTile var3, int var4, int var5);
    }
}

