/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.overlay;

import android.content.Context;
import android.graphics.Point;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.WindowManager;
import com.mapbox.mapboxsdk.api.ILatLng;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.overlay.ItemizedOverlay;
import com.mapbox.mapboxsdk.overlay.Marker;
import com.mapbox.mapboxsdk.views.MapView;
import com.mapbox.mapboxsdk.views.util.Projection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ItemizedIconOverlay
extends ItemizedOverlay {
    protected final List<Marker> mItemList;
    protected OnItemGestureListener<Marker> mOnItemGestureListener;
    private int mDrawnItemsLimit = Integer.MAX_VALUE;
    private MapView view;
    private Context context;

    public ItemizedIconOverlay(Context pContext, List<Marker> pList, OnItemGestureListener<Marker> pOnItemGestureListener) {
        this.context = pContext;
        this.mItemList = pList;
        this.mOnItemGestureListener = pOnItemGestureListener;
        this.populate();
    }

    @Override
    public boolean onSnapToItem(int pX, int pY, Point pSnapPoint, MapView pMapView) {
        return false;
    }

    @Override
    protected void populate() {
        Collections.sort(this.mItemList, new Comparator<Marker>(){

            @Override
            public int compare(Marker a, Marker b) {
                return Double.valueOf(a.getPoint().getLatitude()).compareTo(b.getPoint().getLatitude());
            }
        });
        super.populate();
    }

    @Override
    protected Marker createItem(int index) {
        return this.mItemList.get(index);
    }

    @Override
    public int size() {
        return Math.min(this.mItemList.size(), this.mDrawnItemsLimit);
    }

    public boolean addItem(Marker item) {
        item.setParentHolder(this);
        boolean result = this.mItemList.add(item);
        this.populate();
        return result;
    }

    private boolean activateSelectedItems(MotionEvent event, MapView mapView, ActiveItem task) {
        Projection projection = mapView.getProjection();
        float x = event.getX();
        float y = event.getY();
        for (int i = 0; i < this.mItemList.size(); ++i) {
            Marker item = this.getItem(i);
            if (!this.markerHitTest(item, projection, x, y) || !task.run(i)) continue;
            this.setFocus(item);
            return true;
        }
        return false;
    }

    public boolean addItems(List items) {
        for (Object item : items) {
            if (!(item instanceof Marker)) continue;
            ((Marker)item).setParentHolder(this);
        }
        boolean result = this.mItemList.addAll(items);
        this.populate();
        return result;
    }

    public void removeAllItems() {
        this.removeAllItems(true);
    }

    public void removeAllItems(boolean withPopulate) {
        for (Marker item : this.mItemList) {
            item.setParentHolder(null);
        }
        this.mItemList.clear();
        if (withPopulate) {
            this.populate();
        }
    }

    public boolean removeItem(Marker item) {
        boolean result = this.mItemList.remove(item);
        if (result) {
            item.setParentHolder(null);
        }
        this.populate();
        return result;
    }

    public Marker removeItem(int position) {
        Marker item = this.mItemList.remove(position);
        if (item != null) {
            item.setParentHolder(null);
        }
        this.populate();
        return item;
    }

    public void removeItems(List items) {
        for (Object item : items) {
            boolean result;
            if (!(item instanceof Marker) || !(result = this.mItemList.remove(item))) continue;
            ((Marker)item).setParentHolder(null);
        }
        this.populate();
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent event, final MapView mapView) {
        return this.activateSelectedItems(event, mapView, new ActiveItem(){

            @Override
            public boolean run(int index) {
                ItemizedIconOverlay that = ItemizedIconOverlay.this;
                if (that.mOnItemGestureListener == null) {
                    return false;
                }
                return ItemizedIconOverlay.this.onSingleTapUpHelper(index, that.mItemList.get(index), mapView);
            }
        });
    }

    protected boolean onSingleTapUpHelper(int index, Marker item, MapView mapView) {
        return this.mOnItemGestureListener.onItemSingleTapUp(index, item);
    }

    @Override
    public boolean onLongPress(MotionEvent event, MapView mapView) {
        return this.activateSelectedItems(event, mapView, new ActiveItem(){

            @Override
            public boolean run(int index) {
                ItemizedIconOverlay that = ItemizedIconOverlay.this;
                if (that.mOnItemGestureListener == null) {
                    return false;
                }
                return ItemizedIconOverlay.this.onLongPressHelper(index, ItemizedIconOverlay.this.getItem(index));
            }
        });
    }

    protected boolean onLongPressHelper(int index, Marker item) {
        return this.mOnItemGestureListener.onItemLongPress(index, item);
    }

    private double getThreshold() {
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        DisplayMetrics dm = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(dm);
        return dm.widthPixels;
    }

    private ArrayList<LatLng> getCoordinateList(List<Marker> list) {
        ArrayList<LatLng> theList = new ArrayList<LatLng>();
        for (Marker element : list) {
            theList.add(element.getPoint());
        }
        return theList;
    }

    private float screenX(Marker item) {
        return this.view.getProjection().toMapPixels((ILatLng)item.getPoint(), null).x;
    }

    private float screenY(Marker item) {
        return this.view.getProjection().toMapPixels((ILatLng)item.getPoint(), null).y;
    }

    public int getDrawnItemsLimit() {
        return this.mDrawnItemsLimit;
    }

    public void setDrawnItemsLimit(int aLimit) {
        this.mDrawnItemsLimit = aLimit;
    }

    public static interface ActiveItem {
        public boolean run(int var1);
    }

    public static interface OnItemGestureListener<T> {
        public boolean onItemSingleTapUp(int var1, T var2);

        public boolean onItemLongPress(int var1, T var2);
    }
}

