/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.overlay;

import android.os.AsyncTask;
import android.util.Log;
import com.google.common.base.Strings;
import com.mapbox.mapboxsdk.format.GeoJSON;
import com.mapbox.mapboxsdk.overlay.Marker;
import com.mapbox.mapboxsdk.overlay.PathOverlay;
import com.mapbox.mapboxsdk.util.constants.UtilConstants;
import com.mapbox.mapboxsdk.views.MapView;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class GeoJSONLayer {
    private final MapView mapView;
    static final String TAG = "GeoJSONLayer";

    public GeoJSONLayer(MapView mapView) {
        this.mapView = mapView;
    }

    public void loadURL(String url) {
        if (Strings.isNullOrEmpty((String)url)) {
            return;
        }
        new Getter().execute(new String[]{url});
    }

    private class Getter
    extends AsyncTask<String, Void, ArrayList<Object>> {
        private Getter() {
        }

        protected ArrayList<Object> doInBackground(String ... params) {
            String jsonText = null;
            ArrayList<Object> uiObjects = new ArrayList<Object>();
            try {
                if (UtilConstants.DEBUGMODE) {
                    Log.d((String)GeoJSONLayer.TAG, (String)("Mapbox SDK downloading GeoJSON URL: " + params[0]));
                }
                InputStream is = new URL(params[0]).openStream();
                BufferedReader rd = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
                jsonText = this.readAll(rd);
                List<Object> parsed = GeoJSON.parseString(jsonText, GeoJSONLayer.this.mapView);
                if (UtilConstants.DEBUGMODE) {
                    Log.d((String)GeoJSONLayer.TAG, (String)("Parsed GeoJSON with " + parsed.size() + " features."));
                }
                uiObjects.addAll(parsed);
            }
            catch (Exception e) {
                Log.e((String)GeoJSONLayer.TAG, (String)("Error loading / parsing GeoJSON: " + e.toString()));
                e.printStackTrace();
            }
            return uiObjects;
        }

        protected void onPostExecute(ArrayList<Object> objects) {
            for (Object obj : objects) {
                if (obj instanceof Marker) {
                    GeoJSONLayer.this.mapView.addMarker((Marker)obj);
                    continue;
                }
                if (!(obj instanceof PathOverlay)) continue;
                GeoJSONLayer.this.mapView.getOverlays().add((PathOverlay)obj);
            }
            if (objects.size() > 0) {
                GeoJSONLayer.this.mapView.invalidate();
            }
        }

        private String readAll(Reader rd) throws IOException {
            int cp;
            StringBuilder sb = new StringBuilder();
            while ((cp = rd.read()) != -1) {
                sb.append((char)cp);
            }
            return sb.toString();
        }
    }
}

