/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.places.picker.viewmodel;

import android.app.Application;
import android.arch.lifecycle.AndroidViewModel;
import android.arch.lifecycle.MutableLiveData;
import android.support.annotation.NonNull;
import com.mapbox.api.geocoding.v5.MapboxGeocoding;
import com.mapbox.api.geocoding.v5.models.CarmenFeature;
import com.mapbox.api.geocoding.v5.models.GeocodingResponse;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.plugins.places.picker.model.PlacePickerOptions;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import timber.log.Timber;

public class PlacePickerViewModel
extends AndroidViewModel
implements Callback<GeocodingResponse> {
    private MutableLiveData<CarmenFeature> results = new MutableLiveData();

    public PlacePickerViewModel(@NonNull Application application) {
        super(application);
    }

    public void reverseGeocode(Point point, String accessToken, PlacePickerOptions options) {
        MapboxGeocoding.Builder builder = MapboxGeocoding.builder();
        builder.accessToken(accessToken).query(point);
        if (options != null && options.geocodingTypes() != null) {
            builder.geocodingTypes(new String[]{options.geocodingTypes()});
        }
        if (options != null && options.language() != null) {
            builder.languages(options.language());
        }
        builder.build().enqueueCall((Callback)this);
    }

    public void onResponse(@NonNull Call<GeocodingResponse> call, @NonNull Response<GeocodingResponse> response) {
        if (((GeocodingResponse)response.body()).features().isEmpty()) {
            this.results.setValue(null);
            return;
        }
        this.results.setValue(((GeocodingResponse)response.body()).features().get(0));
    }

    public void onFailure(@NonNull Call<GeocodingResponse> call, Throwable throwable) {
        Timber.e((Throwable)throwable, (String)"error requesting Geocoding request", (Object[])new Object[0]);
    }

    public MutableLiveData<CarmenFeature> getResults() {
        return this.results;
    }
}

