/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.places.autocomplete.ui;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.OnLifecycleEvent;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.mapbox.mapboxsdk.places.R;

public class SearchView
extends LinearLayout
implements View.OnClickListener,
TextWatcher,
LifecycleObserver {
    @Nullable
    private BackButtonListener backButtonListener;
    @Nullable
    private QueryListener queryListener;
    private final ImageView backButton;
    private final ImageView clearButton;
    private final EditText searchEditText;

    public SearchView(@NonNull Context context) {
        this(context, null);
    }

    public SearchView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public SearchView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        SearchView.inflate((Context)context, (int)R.layout.mapbox_view_search, (ViewGroup)this);
        this.backButton = (ImageView)this.findViewById(R.id.button_search_back);
        this.clearButton = (ImageView)this.findViewById(R.id.button_search_clear);
        this.searchEditText = (EditText)this.findViewById(R.id.edittext_search);
        this.initialize();
    }

    private void initialize() {
        this.backButton.setOnClickListener((View.OnClickListener)this);
        this.clearButton.setOnClickListener((View.OnClickListener)this);
        this.searchEditText.addTextChangedListener((TextWatcher)this);
        ((LifecycleOwner)this.getContext()).getLifecycle().addObserver((LifecycleObserver)this);
    }

    public void onClick(View view) {
        if (view.getId() == R.id.button_search_back) {
            if (this.backButtonListener != null) {
                this.backButtonListener.onBackButtonPress();
            }
        } else {
            this.searchEditText.getText().clear();
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void onDestroy() {
        this.backButtonListener = null;
        this.queryListener = null;
    }

    public void setHint(String hint) {
        this.searchEditText.setHint((CharSequence)hint);
    }

    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        if (this.queryListener != null) {
            this.queryListener.onQueryChange(charSequence);
        }
        this.clearButton.setVisibility(charSequence.length() > 0 ? 0 : 4);
    }

    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void afterTextChanged(Editable editable) {
    }

    public void setBackButtonListener(@Nullable BackButtonListener backButtonListener) {
        this.backButtonListener = backButtonListener;
    }

    public void setQueryListener(@Nullable QueryListener queryListener) {
        this.queryListener = queryListener;
    }

    static interface BackButtonListener {
        public void onBackButtonPress();
    }

    static interface QueryListener {
        public void onQueryChange(CharSequence var1);
    }
}

