/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.places.autocomplete.ui;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.mapbox.api.geocoding.v5.models.CarmenFeature;
import com.mapbox.mapboxsdk.places.R;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.ui.ResultClickCallback;
import java.util.List;

public class SearchResultAdapter
extends RecyclerView.Adapter<SearchViewHolder> {
    private static final String ADDRESS = "address";
    @Nullable
    private ResultClickCallback resultClickCallback;
    private final List<CarmenFeature> results;
    private final Context context;

    public SearchResultAdapter(Context context, List<CarmenFeature> results) {
        this.results = results;
        this.context = context;
    }

    public SearchViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        View view = inflater.inflate(R.layout.mapbox_item_search_result, parent, false);
        return new SearchViewHolder(view);
    }

    public void setOnItemClickListener(ResultClickCallback resultClickCallback) {
        this.resultClickCallback = resultClickCallback;
    }

    public void onBindViewHolder(SearchViewHolder holder, int position) {
        if (this.resultClickCallback != null) {
            holder.bind(this.results.get(position), this.resultClickCallback);
        }
        if (this.results.get(position).properties().has("com.mapbox.mapboxsdk.plugins.places.savedcarmenfeat")) {
            holder.placeNameView.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.mapbox_plugins_bright_blue));
        }
        if (this.results.get(position).text() != null) {
            holder.placeNameView.setText((CharSequence)this.results.get(position).text());
        }
        if (this.results.get(position).properties().has(ADDRESS)) {
            holder.addressView.setText((CharSequence)this.results.get(position).properties().getAsJsonPrimitive(ADDRESS).getAsString());
        } else if (this.results.get(position).placeName() != null) {
            holder.addressView.setText((CharSequence)this.results.get(position).placeName());
        } else {
            holder.addressView.setHeight(0);
        }
    }

    public int getItemCount() {
        return null != this.results ? this.results.size() : 0;
    }

    static class SearchViewHolder
    extends RecyclerView.ViewHolder {
        private final TextView placeNameView;
        private final TextView addressView;

        SearchViewHolder(View itemView) {
            super(itemView);
            this.placeNameView = (TextView)itemView.findViewById(R.id.tv_place_name);
            this.addressView = (TextView)itemView.findViewById(R.id.tv_address);
        }

        public void bind(final CarmenFeature carmenFeature, final ResultClickCallback listener) {
            this.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    listener.onClick(carmenFeature);
                }
            });
        }
    }
}

