/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.places.autocomplete.model;

import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.mapbox.api.geocoding.v5.models.CarmenFeature;
import com.mapbox.core.utils.TextUtils;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.plugins.places.autocomplete.model.$AutoValue_PlaceOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

@AutoValue
public abstract class PlaceOptions
implements Parcelable {
    public static final int MODE_FULLSCREEN = 1;
    public static final int MODE_CARDS = 2;

    @Nullable
    public abstract Point proximity();

    @Nullable
    public abstract String language();

    public abstract int limit();

    @Nullable
    public abstract String bbox();

    @Nullable
    public abstract String geocodingTypes();

    @Nullable
    public abstract String country();

    @Nullable
    public abstract List<String> injectedPlaces();

    public abstract int viewMode();

    public abstract int backgroundColor();

    public abstract int toolbarColor();

    @Nullable
    public abstract String hint();

    public static Builder builder() {
        return new $AutoValue_PlaceOptions.Builder().backgroundColor(0).toolbarColor(-1).limit(10);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        private List<String> countries = new ArrayList<String>();
        private List<String> injectedPlaces = new ArrayList<String>();

        public abstract Builder proximity(@Nullable Point var1);

        public abstract Builder language(@Nullable String var1);

        public Builder geocodingTypes(String ... geocodingTypes) {
            this.geocodingTypes(TextUtils.join((CharSequence)",", (Object[])geocodingTypes));
            return this;
        }

        abstract Builder geocodingTypes(String var1);

        public abstract Builder limit(@IntRange(from=1L, to=10L) int var1);

        public Builder bbox(Point southwest, Point northeast) {
            this.bbox(southwest.longitude(), southwest.latitude(), northeast.longitude(), northeast.latitude());
            return this;
        }

        public Builder bbox(@FloatRange(from=-180.0, to=180.0) double minX, @FloatRange(from=-90.0, to=90.0) double minY, @FloatRange(from=-180.0, to=180.0) double maxX, @FloatRange(from=-90.0, to=90.0) double maxY) {
            this.bbox(String.format(Locale.US, "%s,%s,%s,%s", TextUtils.formatCoordinate((double)minX), TextUtils.formatCoordinate((double)minY), TextUtils.formatCoordinate((double)maxX), TextUtils.formatCoordinate((double)maxY)));
            return this;
        }

        public abstract Builder bbox(@NonNull String var1);

        public Builder country(Locale country) {
            this.countries.add(country.getCountry());
            return this;
        }

        public Builder country(String ... country) {
            this.countries.addAll(Arrays.asList(country));
            return this;
        }

        public abstract Builder country(String var1);

        public Builder addInjectedFeature(CarmenFeature carmenFeature) {
            carmenFeature.properties().addProperty("com.mapbox.mapboxsdk.plugins.places.savedcarmenfeat", Boolean.valueOf(true));
            this.injectedPlaces.add(carmenFeature.toJson());
            return this;
        }

        abstract Builder injectedPlaces(List<String> var1);

        abstract Builder viewMode(int var1);

        public abstract Builder backgroundColor(@ColorInt int var1);

        public abstract Builder toolbarColor(@ColorInt int var1);

        public abstract Builder hint(@Nullable String var1);

        abstract PlaceOptions autoBuild();

        public PlaceOptions build() {
            return this.build(1);
        }

        public PlaceOptions build(@IntRange(from=1L, to=2L) int mode) {
            if (!this.countries.isEmpty()) {
                this.country(TextUtils.join((CharSequence)",", (Object[])this.countries.toArray()));
            }
            this.injectedPlaces(this.injectedPlaces);
            this.viewMode(mode);
            return this.autoBuild();
        }
    }
}

