/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.locationlayer;

import android.annotation.SuppressLint;
import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.OnLifecycleEvent;
import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import android.support.annotation.StyleRes;
import android.support.v7.app.AppCompatDelegate;
import com.mapbox.android.core.location.LocationEngine;
import com.mapbox.android.core.location.LocationEngineListener;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.plugins.locationlayer.CompassListener;
import com.mapbox.mapboxsdk.plugins.locationlayer.CompassManager;
import com.mapbox.mapboxsdk.plugins.locationlayer.LocationLayer;
import com.mapbox.mapboxsdk.plugins.locationlayer.LocationLayerAnimator;
import com.mapbox.mapboxsdk.plugins.locationlayer.LocationLayerCamera;
import com.mapbox.mapboxsdk.plugins.locationlayer.LocationLayerOptions;
import com.mapbox.mapboxsdk.plugins.locationlayer.OnCameraMoveInvalidateListener;
import com.mapbox.mapboxsdk.plugins.locationlayer.OnCameraTrackingChangedListener;
import com.mapbox.mapboxsdk.plugins.locationlayer.OnLocationLayerClickListener;
import com.mapbox.mapboxsdk.plugins.locationlayer.OnLocationLayerLongClickListener;
import com.mapbox.mapboxsdk.plugins.locationlayer.OnLocationStaleListener;
import com.mapbox.mapboxsdk.plugins.locationlayer.R;
import com.mapbox.mapboxsdk.plugins.locationlayer.StaleStateManager;
import java.util.concurrent.CopyOnWriteArrayList;

public final class LocationLayerPlugin
implements LifecycleObserver {
    private final MapboxMap mapboxMap;
    private final MapView mapView;
    private LocationLayerOptions options;
    private LocationEngine locationEngine;
    private CompassManager compassManager;
    private LocationLayer locationLayer;
    private LocationLayerCamera locationLayerCamera;
    private LocationLayerAnimator locationLayerAnimator;
    private CameraPosition lastCameraPosition;
    private boolean isEnabled;
    private StaleStateManager staleStateManager;
    private final CopyOnWriteArrayList<OnLocationStaleListener> onLocationStaleListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<OnLocationLayerClickListener> onLocationLayerClickListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<OnLocationLayerLongClickListener> onLocationLayerLongClickListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<OnCameraTrackingChangedListener> onCameraTrackingChangedListeners = new CopyOnWriteArrayList();
    private MapboxMap.OnCameraMoveListener onCameraMoveListener = new MapboxMap.OnCameraMoveListener(){

        public void onCameraMove() {
            LocationLayerPlugin.this.updateLayerOffsets(false);
        }
    };
    private MapboxMap.OnMapClickListener onMapClickListener = new MapboxMap.OnMapClickListener(){

        public void onMapClick(@NonNull LatLng point) {
            if (!LocationLayerPlugin.this.onLocationLayerClickListeners.isEmpty() && LocationLayerPlugin.this.locationLayer.onMapClick(point)) {
                for (OnLocationLayerClickListener listener : LocationLayerPlugin.this.onLocationLayerClickListeners) {
                    listener.onLocationLayerClick();
                }
            }
        }
    };
    private MapboxMap.OnMapLongClickListener onMapLongClickListener = new MapboxMap.OnMapLongClickListener(){

        public void onMapLongClick(@NonNull LatLng point) {
            if (!LocationLayerPlugin.this.onLocationLayerLongClickListeners.isEmpty() && LocationLayerPlugin.this.locationLayer.onMapClick(point)) {
                for (OnLocationLayerLongClickListener listener : LocationLayerPlugin.this.onLocationLayerLongClickListeners) {
                    listener.onLocationLayerLongClick();
                }
            }
        }
    };
    private OnLocationStaleListener onLocationStaleListener = new OnLocationStaleListener(){

        @Override
        public void onStaleStateChange(boolean isStale) {
            LocationLayerPlugin.this.locationLayer.setLocationsStale(isStale);
            for (OnLocationStaleListener listener : LocationLayerPlugin.this.onLocationStaleListeners) {
                listener.onStaleStateChange(isStale);
            }
        }
    };
    private MapView.OnMapChangedListener onMapChangedListener = new MapView.OnMapChangedListener(){

        @SuppressLint(value={"MissingPermission"})
        public void onMapChanged(int change) {
            if (change == 5) {
                LocationLayerPlugin.this.onStop();
            } else if (change == 14) {
                LocationLayerPlugin.this.locationLayer.initializeComponents(LocationLayerPlugin.this.options);
                LocationLayerPlugin.this.locationLayerCamera.initializeOptions(LocationLayerPlugin.this.options);
                LocationLayerPlugin.this.setRenderMode(LocationLayerPlugin.this.locationLayer.getRenderMode());
                LocationLayerPlugin.this.onStart();
            }
        }
    };
    private OnCameraMoveInvalidateListener onCameraMoveInvalidateListener = new OnCameraMoveInvalidateListener(){

        @Override
        public void onInvalidateCameraMove() {
            LocationLayerPlugin.this.onCameraMoveListener.onCameraMove();
        }
    };
    private CompassListener compassListener = new CompassListener(){

        @Override
        public void onCompassChanged(float userHeading) {
            LocationLayerPlugin.this.updateCompassHeading(userHeading);
        }

        @Override
        public void onCompassAccuracyChange(int compassStatus) {
        }
    };
    private LocationEngineListener locationEngineListener = new LocationEngineListener(){

        public void onConnected() {
        }

        public void onLocationChanged(Location location) {
            LocationLayerPlugin.this.updateLocation(location);
        }
    };
    private OnCameraTrackingChangedListener cameraTrackingChangedListener = new OnCameraTrackingChangedListener(){

        @Override
        public void onCameraTrackingDismissed() {
            for (OnCameraTrackingChangedListener listener : LocationLayerPlugin.this.onCameraTrackingChangedListeners) {
                listener.onCameraTrackingDismissed();
            }
        }

        @Override
        public void onCameraTrackingChanged(int currentMode) {
            for (OnCameraTrackingChangedListener listener : LocationLayerPlugin.this.onCameraTrackingChangedListeners) {
                listener.onCameraTrackingChanged(currentMode);
            }
        }
    };

    public LocationLayerPlugin(@NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @Nullable LocationEngine locationEngine) {
        this(mapView, mapboxMap, locationEngine, LocationLayerOptions.createFromAttributes(mapView.getContext(), R.style.mapbox_LocationLayer));
    }

    public LocationLayerPlugin(@NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @Nullable LocationEngine locationEngine, @StyleRes int styleRes) {
        this(mapView, mapboxMap, locationEngine, LocationLayerOptions.createFromAttributes(mapView.getContext(), styleRes));
    }

    public LocationLayerPlugin(@NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @Nullable LocationEngine locationEngine, LocationLayerOptions options) {
        this.locationEngine = locationEngine;
        this.mapboxMap = mapboxMap;
        this.mapView = mapView;
        this.options = options;
        this.initialize();
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"})
    public void setLocationLayerEnabled(boolean isEnabled) {
        if (isEnabled) {
            this.enableLocationLayerPlugin();
        } else {
            this.disableLocationLayerPlugin();
        }
    }

    public void setCameraMode(int cameraMode) {
        boolean isGpsNorth = cameraMode == 36;
        this.locationLayerAnimator.resetAllCameraAnimations(this.mapboxMap.getCameraPosition(), isGpsNorth);
        this.locationLayerCamera.setCameraMode(cameraMode);
    }

    public int getCameraMode() {
        return this.locationLayerCamera.getCameraMode();
    }

    public void setRenderMode(int renderMode) {
        this.locationLayer.setRenderMode(renderMode);
        this.updateLayerOffsets(true);
    }

    public int getRenderMode() {
        return this.locationLayer.getRenderMode();
    }

    public LocationLayerOptions getLocationLayerOptions() {
        return this.options;
    }

    public void applyStyle(@StyleRes int styleRes) {
        this.applyStyle(LocationLayerOptions.createFromAttributes(this.mapView.getContext(), styleRes));
    }

    public void applyStyle(LocationLayerOptions options) {
        this.options = options;
        this.locationLayer.applyStyle(options);
        if (!options.enableStaleState()) {
            this.staleStateManager.onStop();
        }
        this.staleStateManager.setDelayTime(options.staleStateTimeout());
        this.updateMapWithOptions(options);
    }

    public void forceLocationUpdate(@Nullable Location location) {
        this.updateLocation(location);
    }

    public void setLocationEngine(@Nullable LocationEngine locationEngine) {
        if (this.locationEngine != null) {
            this.locationEngine.removeLocationEngineListener(this.locationEngineListener);
            this.locationEngine = null;
        }
        if (locationEngine != null) {
            this.locationEngine = locationEngine;
            if (this.isEnabled) {
                this.locationEngine.addLocationEngineListener(this.locationEngineListener);
            }
        }
    }

    @Nullable
    public LocationEngine getLocationEngine() {
        return this.locationEngine;
    }

    @SuppressLint(value={"MissingPermission"})
    @Nullable
    public Location getLastKnownLocation() {
        return this.locationEngine != null ? this.locationEngine.getLastLocation() : null;
    }

    public void addCompassListener(@NonNull CompassListener compassListener) {
        this.compassManager.addCompassListener(compassListener);
    }

    public void removeCompassListener(@NonNull CompassListener compassListener) {
        this.compassManager.removeCompassListener(compassListener);
    }

    public void addOnLocationClickListener(@NonNull OnLocationLayerClickListener listener) {
        this.onLocationLayerClickListeners.add(listener);
    }

    public void removeOnLocationClickListener(@NonNull OnLocationLayerClickListener listener) {
        this.onLocationLayerClickListeners.remove(listener);
    }

    public void addOnLocationLongClickListener(@NonNull OnLocationLayerLongClickListener listener) {
        this.onLocationLayerLongClickListeners.add(listener);
    }

    public void removeOnLocationLongClickListener(@NonNull OnLocationLayerLongClickListener listener) {
        this.onLocationLayerLongClickListeners.remove(listener);
    }

    public void addOnCameraTrackingChangedListener(@NonNull OnCameraTrackingChangedListener listener) {
        this.onCameraTrackingChangedListeners.add(listener);
    }

    public void removeOnCameraTrackingChangedListener(@NonNull OnCameraTrackingChangedListener listener) {
        this.onCameraTrackingChangedListeners.remove(listener);
    }

    public void addOnLocationStaleListener(@NonNull OnLocationStaleListener listener) {
        this.onLocationStaleListeners.add(listener);
    }

    public void removeOnLocationStaleListener(@NonNull OnLocationStaleListener listener) {
        this.onLocationStaleListeners.remove(listener);
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
    @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"})
    public void onStart() {
        if (this.isEnabled) {
            if (this.locationEngine != null) {
                this.locationEngine.addLocationEngineListener(this.locationEngineListener);
            }
            this.setLastLocation();
            this.setLastCompassHeading();
        }
        if (this.mapboxMap != null) {
            this.mapboxMap.addOnCameraMoveListener(this.onCameraMoveListener);
        }
        if (this.options.enableStaleState()) {
            this.staleStateManager.onStart();
        }
        this.compassManager.onStart();
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    public void onStop() {
        this.staleStateManager.onStop();
        this.compassManager.onStop();
        this.locationLayerAnimator.cancelAllAnimations();
        if (this.locationEngine != null) {
            this.locationEngine.removeLocationEngineListener(this.locationEngineListener);
        }
        if (this.mapboxMap != null) {
            this.mapboxMap.removeOnCameraMoveListener(this.onCameraMoveListener);
        }
    }

    private void initialize() {
        AppCompatDelegate.setCompatVectorFromResourcesEnabled((boolean)true);
        this.mapView.addOnMapChangedListener(this.onMapChangedListener);
        this.mapboxMap.addOnMapClickListener(this.onMapClickListener);
        this.mapboxMap.addOnMapLongClickListener(this.onMapLongClickListener);
        this.locationLayer = new LocationLayer(this.mapView, this.mapboxMap, this.options);
        this.locationLayerCamera = new LocationLayerCamera(this.mapView.getContext(), this.mapboxMap, this.cameraTrackingChangedListener, this.options, this.onCameraMoveInvalidateListener);
        this.locationLayerAnimator = new LocationLayerAnimator();
        this.locationLayerAnimator.addLayerListener(this.locationLayer);
        this.locationLayerAnimator.addCameraListener(this.locationLayerCamera);
        this.compassManager = new CompassManager(this.mapView.getContext());
        this.compassManager.addCompassListener(this.compassListener);
        this.staleStateManager = new StaleStateManager(this.onLocationStaleListener, this.options.staleStateTimeout());
        this.updateMapWithOptions(this.options);
        this.enableLocationLayerPlugin();
    }

    @SuppressLint(value={"MissingPermission"})
    private void enableLocationLayerPlugin() {
        this.isEnabled = true;
        this.onStart();
        this.locationLayer.show();
    }

    private void disableLocationLayerPlugin() {
        this.isEnabled = false;
        this.onStop();
        this.locationLayer.hide();
    }

    private void updateMapWithOptions(LocationLayerOptions options) {
        this.mapboxMap.setPadding(options.padding()[0], options.padding()[1], options.padding()[2], options.padding()[3]);
        this.mapboxMap.setMaxZoomPreference(options.maxZoom());
        this.mapboxMap.setMinZoomPreference(options.minZoom());
    }

    private void updateLocation(Location location) {
        if (location == null) {
            return;
        }
        this.staleStateManager.updateLatestLocationTime();
        CameraPosition currentCameraPosition = this.mapboxMap.getCameraPosition();
        boolean isGpsNorth = this.getCameraMode() == 36;
        this.locationLayerAnimator.feedNewLocation(location, currentCameraPosition, isGpsNorth);
        this.locationLayer.updateAccuracyRadius(location);
    }

    private void updateCompassHeading(float heading) {
        this.locationLayerAnimator.feedNewCompassBearing(heading, this.mapboxMap.getCameraPosition());
    }

    private void setLastLocation() {
        if (this.locationEngine != null) {
            this.updateLocation(this.locationEngine.getLastLocation());
        }
    }

    private void setLastCompassHeading() {
        this.updateCompassHeading(this.compassManager.getLastHeading());
    }

    private void updateLayerOffsets(boolean forceUpdate) {
        CameraPosition position = this.mapboxMap.getCameraPosition();
        if (this.lastCameraPosition == null || forceUpdate) {
            this.lastCameraPosition = position;
            this.locationLayer.updateForegroundBearing((float)position.bearing);
            this.locationLayer.updateForegroundOffset(position.tilt);
            this.locationLayer.updateAccuracyRadius(this.getLastKnownLocation());
            return;
        }
        if (position.bearing != this.lastCameraPosition.bearing) {
            this.locationLayer.updateForegroundBearing((float)position.bearing);
        }
        if (position.tilt != this.lastCameraPosition.tilt) {
            this.locationLayer.updateForegroundOffset(position.tilt);
        }
        if (position.zoom != this.lastCameraPosition.zoom) {
            this.locationLayer.updateAccuracyRadius(this.getLastKnownLocation());
        }
        this.lastCameraPosition = position;
    }
}

