/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.locationlayer;

import android.content.Context;
import android.graphics.PointF;
import android.view.MotionEvent;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.MoveGestureDetector;
import com.mapbox.android.gestures.RotateGestureDetector;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.plugins.locationlayer.LocationLayerAnimator;
import com.mapbox.mapboxsdk.plugins.locationlayer.LocationLayerOptions;
import com.mapbox.mapboxsdk.plugins.locationlayer.OnCameraMoveInvalidateListener;
import com.mapbox.mapboxsdk.plugins.locationlayer.OnCameraTrackingChangedListener;
import java.util.List;
import java.util.Set;

final class LocationLayerCamera
implements LocationLayerAnimator.OnCameraAnimationsValuesChangeListener {
    private int cameraMode;
    private final MapboxMap mapboxMap;
    private final OnCameraTrackingChangedListener internalCameraTrackingChangedListener;
    private LocationLayerOptions options;
    private boolean adjustFocalPoint;
    private final MoveGestureDetector moveGestureDetector;
    private final OnCameraMoveInvalidateListener onCameraMoveInvalidateListener;
    private MapboxMap.OnMoveListener onMoveListener = new MapboxMap.OnMoveListener(){
        private boolean interrupt;

        public void onMoveBegin(MoveGestureDetector detector) {
            if (detector.getPointersCount() > 1 && detector.getMoveThreshold() != LocationLayerCamera.this.options.trackingMultiFingerMoveThreshold() && LocationLayerCamera.this.isLocationTracking()) {
                detector.setMoveThreshold(LocationLayerCamera.this.options.trackingMultiFingerMoveThreshold());
                this.interrupt = true;
            }
        }

        public void onMove(MoveGestureDetector detector) {
            if (this.interrupt) {
                detector.interrupt();
                return;
            }
            if (LocationLayerCamera.this.isLocationTracking()) {
                LocationLayerCamera.this.setCameraMode(0);
            }
        }

        public void onMoveEnd(MoveGestureDetector detector) {
            if (!this.interrupt && LocationLayerCamera.this.isLocationTracking()) {
                LocationLayerCamera.this.moveGestureDetector.setMoveThreshold(LocationLayerCamera.this.options.trackingInitialMoveThreshold());
            }
            this.interrupt = false;
        }
    };
    private MapboxMap.OnRotateListener onRotateListener = new MapboxMap.OnRotateListener(){

        public void onRotateBegin(RotateGestureDetector detector) {
            if (LocationLayerCamera.this.isBearingTracking()) {
                LocationLayerCamera.this.setCameraMode(0);
            }
        }

        public void onRotate(RotateGestureDetector detector) {
        }

        public void onRotateEnd(RotateGestureDetector detector) {
        }
    };

    LocationLayerCamera(Context context, MapboxMap mapboxMap, OnCameraTrackingChangedListener internalCameraTrackingChangedListener, LocationLayerOptions options, OnCameraMoveInvalidateListener onCameraMoveInvalidateListener) {
        this.mapboxMap = mapboxMap;
        mapboxMap.setGesturesManager((AndroidGesturesManager)new PluginsGesturesManager(context), true, true);
        this.moveGestureDetector = mapboxMap.getGesturesManager().getMoveGestureDetector();
        mapboxMap.addOnMoveListener(this.onMoveListener);
        mapboxMap.addOnRotateListener(this.onRotateListener);
        this.internalCameraTrackingChangedListener = internalCameraTrackingChangedListener;
        this.onCameraMoveInvalidateListener = onCameraMoveInvalidateListener;
        this.initializeOptions(options);
    }

    void initializeOptions(LocationLayerOptions options) {
        this.options = options;
    }

    void setCameraMode(int cameraMode) {
        boolean wasTracking = this.isLocationTracking();
        this.cameraMode = cameraMode;
        this.mapboxMap.cancelTransitions();
        this.adjustGesturesThresholds();
        this.notifyCameraTrackingChangeListener(wasTracking);
    }

    int getCameraMode() {
        return this.cameraMode;
    }

    private void setBearing(float bearing) {
        this.mapboxMap.moveCamera(CameraUpdateFactory.bearingTo((double)bearing));
        this.onCameraMoveInvalidateListener.onInvalidateCameraMove();
    }

    private void setLatLng(LatLng latLng) {
        this.mapboxMap.moveCamera(CameraUpdateFactory.newLatLng((LatLng)latLng));
        this.onCameraMoveInvalidateListener.onInvalidateCameraMove();
    }

    @Override
    public void onNewLatLngValue(LatLng latLng) {
        if (this.cameraMode == 24 || this.cameraMode == 32 || this.cameraMode == 34 || this.cameraMode == 36) {
            this.setLatLng(latLng);
        }
        if (this.adjustFocalPoint) {
            PointF focalPoint = this.mapboxMap.getProjection().toScreenLocation(latLng);
            this.mapboxMap.getUiSettings().setFocalPoint(focalPoint);
            this.adjustFocalPoint = false;
        }
    }

    @Override
    public void onNewGpsBearingValue(float gpsBearing) {
        boolean trackingNorth;
        boolean bl = trackingNorth = this.cameraMode == 36 && this.mapboxMap.getCameraPosition().bearing != 0.0;
        if (this.cameraMode == 34 || this.cameraMode == 22 || trackingNorth) {
            this.setBearing(gpsBearing);
        }
    }

    @Override
    public void onNewCompassBearingValue(float compassBearing) {
        if (this.cameraMode == 32 || this.cameraMode == 16) {
            this.setBearing(compassBearing);
        }
    }

    private void adjustGesturesThresholds() {
        if (this.isLocationTracking()) {
            this.adjustFocalPoint = true;
            this.moveGestureDetector.setMoveThreshold(this.options.trackingInitialMoveThreshold());
        } else {
            this.moveGestureDetector.setMoveThreshold(0.0f);
        }
    }

    private boolean isLocationTracking() {
        return this.cameraMode == 24 || this.cameraMode == 32 || this.cameraMode == 34 || this.cameraMode == 36;
    }

    private boolean isBearingTracking() {
        return this.cameraMode == 16 || this.cameraMode == 32 || this.cameraMode == 22 || this.cameraMode == 34 || this.cameraMode == 36;
    }

    private void notifyCameraTrackingChangeListener(boolean wasTracking) {
        this.internalCameraTrackingChangedListener.onCameraTrackingChanged(this.cameraMode);
        if (wasTracking && !this.isLocationTracking()) {
            this.mapboxMap.getUiSettings().setFocalPoint(null);
            this.internalCameraTrackingChangedListener.onCameraTrackingDismissed();
        }
    }

    private class PluginsGesturesManager
    extends AndroidGesturesManager {
        public PluginsGesturesManager(Context context) {
            super(context);
        }

        public PluginsGesturesManager(Context context, boolean applyDefaultThresholds) {
            super(context, applyDefaultThresholds);
        }

        public PluginsGesturesManager(Context context, Set<Integer>[] exclusiveGestures) {
            super(context, (Set[])exclusiveGestures);
        }

        public PluginsGesturesManager(Context context, List<Set<Integer>> exclusiveGestures, boolean applyDefaultThresholds) {
            super(context, exclusiveGestures, applyDefaultThresholds);
        }

        public boolean onTouchEvent(MotionEvent motionEvent) {
            int action;
            if (motionEvent != null && (action = motionEvent.getActionMasked()) == 1) {
                LocationLayerCamera.this.adjustGesturesThresholds();
            }
            return super.onTouchEvent(motionEvent);
        }
    }
}

