/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.locationlayer;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.location.Location;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.plugins.locationlayer.LocationLayerAnimator;
import com.mapbox.mapboxsdk.plugins.locationlayer.LocationLayerOptions;
import com.mapbox.mapboxsdk.plugins.locationlayer.R;
import com.mapbox.mapboxsdk.plugins.locationlayer.Utils;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.CircleLayer;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.SymbolLayer;
import com.mapbox.mapboxsdk.style.sources.GeoJsonOptions;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import com.mapbox.mapboxsdk.style.sources.Source;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class LocationLayer
implements LocationLayerAnimator.OnLayerAnimationsValuesChangeListener {
    private int renderMode;
    private final MapboxMap mapboxMap;
    private LocationLayerOptions options;
    private Context context;
    private final Map<String, Layer> layerMap = new HashMap<String, Layer>();
    private Feature locationFeature = Feature.fromGeometry((Geometry)Point.fromLngLat((double)0.0, (double)0.0));
    private GeoJsonSource locationSource;
    private boolean isSourceInitialized;

    LocationLayer(MapView mapView, MapboxMap mapboxMap, LocationLayerOptions options) {
        this.mapboxMap = mapboxMap;
        this.context = mapView.getContext();
        this.initializeComponents(options);
        this.setRenderMode(18);
    }

    void initializeComponents(LocationLayerOptions options) {
        this.prepareLocationSource();
        this.addLayers();
        this.applyStyle(options);
    }

    void applyStyle(@NonNull LocationLayerOptions options) {
        this.options = options;
        float elevation = options.elevation();
        if (elevation > 0.0f) {
            this.styleShadow(options);
        }
        this.styleForeground(options);
        this.styleBackground(options);
        this.styleBearing(options);
        this.styleAccuracy(options.accuracyAlpha(), options.accuracyColor());
    }

    void setRenderMode(int renderMode) {
        this.renderMode = renderMode;
        boolean isStale = this.locationFeature.getBooleanProperty("mapbox-property-location-stale");
        switch (renderMode) {
            case 18: {
                this.styleForeground(this.options);
                this.setLayerVisibility("mapbox-location-shadow", true);
                this.setLayerVisibility("mapbox-location-layer", true);
                this.setLayerVisibility("mapbox-location-stroke-layer", true);
                this.setLayerVisibility("mapbox-location-accuracy-layer", !isStale);
                this.setLayerVisibility("mapbox-location-bearing-layer", false);
                break;
            }
            case 4: {
                this.styleForeground(this.options);
                this.setLayerVisibility("mapbox-location-shadow", true);
                this.setLayerVisibility("mapbox-location-layer", true);
                this.setLayerVisibility("mapbox-location-stroke-layer", true);
                this.setLayerVisibility("mapbox-location-accuracy-layer", !isStale);
                this.setLayerVisibility("mapbox-location-bearing-layer", true);
                break;
            }
            case 8: {
                this.styleForeground(this.options);
                this.setLayerVisibility("mapbox-location-shadow", false);
                this.setLayerVisibility("mapbox-location-layer", true);
                this.setLayerVisibility("mapbox-location-stroke-layer", true);
                this.setLayerVisibility("mapbox-location-accuracy-layer", false);
                this.setLayerVisibility("mapbox-location-bearing-layer", false);
                break;
            }
        }
    }

    int getRenderMode() {
        return this.renderMode;
    }

    void show() {
        this.setRenderMode(this.renderMode);
    }

    void hide() {
        for (String layerId : this.layerMap.keySet()) {
            this.setLayerVisibility(layerId, false);
        }
    }

    private void setLayerVisibility(String layerId, boolean visible) {
        String targetVisibility;
        Layer layer = this.layerMap.get(layerId);
        String string = targetVisibility = visible ? "visible" : "none";
        if (!((String)layer.getVisibility().value).equals(targetVisibility)) {
            layer.setProperties(new PropertyValue[]{PropertyFactory.visibility((String)(visible ? "visible" : "none"))});
        }
    }

    private void addLayers() {
        this.addSymbolLayer("mapbox-location-shadow", "mapbox-location-stroke-layer");
        this.addSymbolLayer("mapbox-location-stroke-layer", "mapbox-location-layer");
        this.addSymbolLayer("mapbox-location-layer", null);
        this.addSymbolLayer("mapbox-location-bearing-layer", null);
        this.addAccuracyLayer();
    }

    private void addSymbolLayer(String layerId, String beforeLayerId) {
        SymbolLayer layer = new SymbolLayer(layerId, "mapbox-location-source");
        layer.setProperties(new PropertyValue[]{PropertyFactory.iconAllowOverlap((Boolean)true), PropertyFactory.iconIgnorePlacement((Boolean)true), PropertyFactory.iconSize((Expression)Expression.interpolate((Expression.Interpolator)Expression.exponential((Number)Float.valueOf(1.0f)), (Expression)Expression.zoom(), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.6f)), Expression.stop((Object)Float.valueOf(18.0f), (Object)Float.valueOf(1.2f))})), PropertyFactory.iconRotationAlignment((String)"map"), PropertyFactory.iconRotate((Expression)Expression.match((Expression)Expression.literal((String)layerId), (Expression)Expression.literal((Number)Float.valueOf(0.0f)), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)"mapbox-location-layer", (Object)Expression.get((String)"mapbox-property-gps-bearing")), Expression.stop((Object)"mapbox-location-stroke-layer", (Object)Expression.get((String)"mapbox-property-gps-bearing")), Expression.stop((Object)"mapbox-location-shadow", (Object)Expression.get((String)"mapbox-property-gps-bearing")), Expression.stop((Object)"mapbox-location-bearing-layer", (Object)Expression.get((String)"mapbox-property-compass-bearing"))})), PropertyFactory.iconImage((Expression)Expression.match((Expression)Expression.literal((String)layerId), (Expression)Expression.literal((String)""), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)"mapbox-location-layer", (Object)Expression.switchCase((Expression[])new Expression[]{Expression.get((String)"mapbox-property-location-stale"), Expression.literal((String)"mapbox-location-stale-icon"), Expression.literal((String)"mapbox-location-icon")})), Expression.stop((Object)"mapbox-location-stroke-layer", (Object)Expression.switchCase((Expression[])new Expression[]{Expression.get((String)"mapbox-property-location-stale"), Expression.literal((String)"mapbox-location-background-stale-icon"), Expression.literal((String)"mapbox-location-stroke-icon")})), Expression.stop((Object)"mapbox-location-shadow", (Object)Expression.literal((String)"mapbox-location-shadow-icon")), Expression.stop((Object)"mapbox-location-bearing-layer", (Object)Expression.literal((String)"mapbox-location-bearing-icon"))})), PropertyFactory.iconOffset((Expression)Expression.match((Expression)Expression.literal((String)layerId), (Expression)Expression.literal((Object[])new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f)}), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)Expression.literal((String)"mapbox-location-layer"), (Object)Expression.get((String)"mapbox-property-foreground-icon-offset")), Expression.stop((Object)Expression.literal((String)"mapbox-location-shadow"), (Object)Expression.get((String)"mapbox-property-shadow-icon-offset"))}))});
        this.addLayerToMap((Layer)layer, beforeLayerId);
    }

    private void addAccuracyLayer() {
        CircleLayer locationAccuracyLayer = new CircleLayer("mapbox-location-accuracy-layer", "mapbox-location-source").withProperties(new PropertyValue[]{PropertyFactory.circleRadius((Expression)Expression.get((String)"mapbox-property-accuracy-radius")), PropertyFactory.circleColor((Expression)Expression.get((String)"mapbox-property-accuracy-color")), PropertyFactory.circleOpacity((Expression)Expression.get((String)"mapbox-property-accuracy-alpha")), PropertyFactory.circleStrokeColor((Expression)Expression.get((String)"mapbox-property-accuracy-color")), PropertyFactory.circlePitchAlignment((String)"map")});
        this.addLayerToMap((Layer)locationAccuracyLayer, "mapbox-location-stroke-layer");
    }

    private void addLayerToMap(Layer layer, @Nullable String idBelowLayer) {
        if (idBelowLayer == null) {
            this.mapboxMap.addLayer(layer);
        } else {
            this.mapboxMap.addLayerBelow(layer, idBelowLayer);
        }
        this.layerMap.put(layer.getId(), layer);
    }

    private void setBearingProperty(String propertyId, float bearing) {
        this.locationFeature.addNumberProperty(propertyId, (Number)Float.valueOf(bearing));
        this.refreshSource();
    }

    void updateAccuracyRadius(Location location) {
        if (this.renderMode == 4 || this.renderMode == 18) {
            this.locationFeature.addNumberProperty("mapbox-property-accuracy-radius", (Number)Float.valueOf(this.calculateZoomLevelRadius(location)));
            this.refreshSource();
        }
    }

    private float calculateZoomLevelRadius(Location location) {
        if (location == null) {
            return 0.0f;
        }
        double metersPerPixel = this.mapboxMap.getProjection().getMetersPerPixelAtLatitude(location.getLatitude());
        return (float)((double)location.getAccuracy() * (1.0 / metersPerPixel));
    }

    void updateForegroundOffset(double tilt) {
        JsonArray foregroundJsonArray = new JsonArray();
        foregroundJsonArray.add((Number)Float.valueOf(0.0f));
        foregroundJsonArray.add((Number)Float.valueOf((float)(-0.05 * tilt)));
        this.locationFeature.addProperty("mapbox-property-foreground-icon-offset", (JsonElement)foregroundJsonArray);
        JsonArray backgroundJsonArray = new JsonArray();
        backgroundJsonArray.add((Number)Float.valueOf(0.0f));
        backgroundJsonArray.add((Number)Float.valueOf((float)(0.05 * tilt)));
        this.locationFeature.addProperty("mapbox-property-shadow-icon-offset", (JsonElement)backgroundJsonArray);
        this.refreshSource();
    }

    void updateForegroundBearing(float bearing) {
        if (this.renderMode != 8) {
            this.setBearingProperty("mapbox-property-gps-bearing", bearing);
        }
    }

    private void prepareLocationSource() {
        this.locationFeature.addNumberProperty("mapbox-property-gps-bearing", (Number)Float.valueOf(0.0f));
        this.locationFeature.addNumberProperty("mapbox-property-compass-bearing", (Number)Float.valueOf(0.0f));
        this.locationFeature.addBooleanProperty("mapbox-property-location-stale", Boolean.valueOf(false));
        this.locationSource = new GeoJsonSource("mapbox-location-source", this.locationFeature, new GeoJsonOptions().withMaxZoom(16));
    }

    private void addLocationSource() {
        this.mapboxMap.addSource((Source)this.locationSource);
        this.isSourceInitialized = true;
    }

    private void refreshSource() {
        this.locationSource.setGeoJson(this.locationFeature);
    }

    private void setLocationPoint(Point locationPoint) {
        JsonObject properties = this.locationFeature.properties();
        if (properties != null) {
            this.locationFeature = Feature.fromGeometry((Geometry)locationPoint, (JsonObject)properties);
            this.locationSource.setGeoJson(this.locationFeature);
        }
        if (!this.isSourceInitialized) {
            this.addLocationSource();
        }
    }

    private void styleBackground(LocationLayerOptions options) {
        Drawable backgroundDrawable = Utils.getDrawable(this.context, options.backgroundDrawable(), options.backgroundTintColor());
        Drawable backgroundDrawableStale = Utils.getDrawable(this.context, options.backgroundDrawableStale(), options.backgroundStaleTintColor());
        this.mapboxMap.addImage("mapbox-location-stroke-icon", Utils.getBitmapFromDrawable(backgroundDrawable));
        this.mapboxMap.addImage("mapbox-location-background-stale-icon", Utils.getBitmapFromDrawable(backgroundDrawableStale));
    }

    private void styleShadow(LocationLayerOptions options) {
        Drawable shadowDrawable = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.mapbox_user_icon_shadow);
        this.mapboxMap.addImage("mapbox-location-shadow-icon", Utils.generateShadow(shadowDrawable, options.elevation()));
    }

    private void styleBearing(LocationLayerOptions options) {
        Drawable bearingDrawable = Utils.getDrawable(this.context, options.bearingDrawable(), options.bearingTintColor());
        this.mapboxMap.addImage("mapbox-location-bearing-icon", Utils.getBitmapFromDrawable(bearingDrawable));
    }

    private void styleAccuracy(float accuracyAlpha, @ColorInt int accuracyColor) {
        this.locationFeature.addNumberProperty("mapbox-property-accuracy-alpha", (Number)Float.valueOf(accuracyAlpha));
        this.locationFeature.addNumberProperty("mapbox-property-accuracy-color", (Number)accuracyColor);
        this.refreshSource();
    }

    private void styleForeground(Drawable foregroundDrawable, Drawable foregroundDrawableStale) {
        this.mapboxMap.addImage("mapbox-location-icon", Utils.getBitmapFromDrawable(foregroundDrawable));
        this.mapboxMap.addImage("mapbox-location-stale-icon", Utils.getBitmapFromDrawable(foregroundDrawableStale));
    }

    private void styleForeground(@NonNull LocationLayerOptions options) {
        if (this.renderMode == 8) {
            this.styleForegroundGPS(options);
        } else {
            this.styleForeground(Utils.getDrawable(this.context, options.foregroundDrawable(), options.foregroundTintColor()), Utils.getDrawable(this.context, options.foregroundDrawableStale(), options.foregroundStaleTintColor()));
        }
    }

    private void styleForegroundGPS(LocationLayerOptions options) {
        this.styleForeground(Utils.getDrawable(this.context, options.gpsDrawable(), options.foregroundTintColor()), Utils.getDrawable(this.context, options.gpsDrawable(), options.foregroundStaleTintColor()));
    }

    void setLocationsStale(boolean isStale) {
        this.locationFeature.addBooleanProperty("mapbox-property-location-stale", Boolean.valueOf(isStale));
        this.refreshSource();
        if (this.renderMode != 8) {
            this.setLayerVisibility("mapbox-location-accuracy-layer", !isStale);
        }
    }

    boolean onMapClick(LatLng point) {
        PointF screenLoc = this.mapboxMap.getProjection().toScreenLocation(point);
        List features = this.mapboxMap.queryRenderedFeatures(screenLoc, new String[]{"mapbox-location-stroke-layer", "mapbox-location-layer", "mapbox-location-bearing-layer"});
        return !features.isEmpty();
    }

    @Override
    public void onNewLatLngValue(LatLng latLng) {
        Point point = Point.fromLngLat((double)latLng.getLongitude(), (double)latLng.getLatitude());
        this.setLocationPoint(point);
    }

    @Override
    public void onNewGpsBearingValue(float gpsBearing) {
        if (this.renderMode == 8) {
            this.setBearingProperty("mapbox-property-gps-bearing", gpsBearing);
        }
    }

    @Override
    public void onNewCompassBearingValue(float compassBearing) {
        if (this.renderMode == 4) {
            this.setBearingProperty("mapbox-property-compass-bearing", compassBearing);
        }
    }
}

