/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.localization;

import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.plugins.localization.MapLocale;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.SymbolLayer;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.mapboxsdk.style.sources.VectorSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import timber.log.Timber;

@UiThread
public final class LocalizationPlugin {
    private static final List<String> SUPPORTED_SOURCES = new ArrayList<String>();
    private static final String EXPRESSION_REGEX = "\\b(name|name_.{2,7})\\b";
    private static final String EXPRESSION_V8_REGEX_BASE = "\\[\"get\", \"name_en\"], \\[\"get\", \"name\"]";
    private static final String EXPRESSION_V8_TEMPLATE_BASE = "[\"get\", \"name_en\"], [\"get\", \"name\"]";
    private static final String EXPRESSION_V8_REGEX_LOCALIZED = "\\[\"match\", \"(name|name_.{2,7})\", \"name_zh-Hant\", \\[\"coalesce\", \\[\"get\", \"name_zh-Hant\"], \\[\"get\", \"name_zh-Hans\"], \\[\"match\", \\[\"get\", \"name_script\"], \"Latin\", \\[\"get\", \"name\"], \\[\"get\", \"name_en\"]], \\[\"get\", \"name\"]], \\[\"coalesce\", \\[\"get\", \"(name|name_.{2,7})\"], \\[\"match\", \\[\"get\", \"name_script\"], \"Latin\", \\[\"get\", \"name\"], \\[\"get\", \"name_en\"]], \\[\"get\", \"name\"]]]";
    private static final String EXPRESSION_V8_TEMPLATE_LOCALIZED = "[\"match\", \"%s\", \"name_zh-Hant\", [\"coalesce\", [\"get\", \"name_zh-Hant\"], [\"get\", \"name_zh-Hans\"], [\"match\", [\"get\", \"name_script\"], \"Latin\", [\"get\", \"name\"], [\"get\", \"name_en\"]], [\"get\", \"name\"]], [\"coalesce\", [\"get\", \"%s\"], [\"match\", [\"get\", \"name_script\"], \"Latin\", [\"get\", \"name\"], [\"get\", \"name_en\"]], [\"get\", \"name\"]]]";
    private static final String STEP_REGEX = "\\[\"zoom\"], ";
    private static final String STEP_TEMPLATE = "[\"zoom\"], \"\", ";
    private final MapboxMap mapboxMap;
    private MapLocale mapLocale;
    @NonNull
    private Style style;

    public LocalizationPlugin(@NonNull MapView mapView, final @NonNull MapboxMap mapboxMap, @NonNull Style style) {
        this.mapboxMap = mapboxMap;
        this.style = style;
        if (!style.isFullyLoaded()) {
            throw new RuntimeException("The style has to be non-null and fully loaded.");
        }
        mapView.addOnDidFinishLoadingStyleListener(new MapView.OnDidFinishLoadingStyleListener(){

            public void onDidFinishLoadingStyle() {
                mapboxMap.getStyle(new Style.OnStyleLoaded(){

                    public void onStyleLoaded(@NonNull Style style) {
                        LocalizationPlugin.this.style = style;
                        if (LocalizationPlugin.this.mapLocale != null) {
                            LocalizationPlugin.this.setMapLanguage(LocalizationPlugin.this.mapLocale);
                        }
                    }
                });
            }
        });
    }

    private MapLocale getChineseMapLocale(MapLocale mapLocale, boolean isStreetsV7) {
        if (isStreetsV7) {
            if (mapLocale.equals(MapLocale.CHINESE_HANS)) {
                return mapLocale;
            }
            return MapLocale.CHINA;
        }
        return MapLocale.CHINA;
    }

    public void matchMapLanguageWithDeviceDefault() {
        this.setMapLanguage(Locale.getDefault(), false);
    }

    public void matchMapLanguageWithDeviceDefault(boolean acceptFallback) {
        this.setMapLanguage(Locale.getDefault(), acceptFallback);
    }

    public void setMapLanguage(String language) {
        this.setMapLanguage(new MapLocale(language));
    }

    public void setMapLanguage(@NonNull Locale locale) {
        this.setMapLanguage(locale, false);
    }

    public void setMapLanguage(@NonNull Locale locale, boolean acceptFallback) {
        MapLocale mapLocale = MapLocale.getMapLocale(locale, acceptFallback);
        if (mapLocale != null) {
            Timber.d((String)"Locale: %s, set MapLocale: %s", (Object[])new Object[]{locale.toString(), mapLocale.getMapLanguage()});
            this.setMapLanguage(mapLocale);
        } else {
            Timber.e((String)"Couldn't match Locale %s %s to a MapLocale", (Object[])new Object[]{locale.toString(), locale.getDisplayName()});
        }
    }

    public void setMapLanguage(@NonNull MapLocale mapLocale) {
        this.mapLocale = mapLocale;
        if (!this.style.isFullyLoaded()) {
            return;
        }
        List layers = this.style.getLayers();
        for (Source source : this.style.getSources()) {
            if (this.sourceIsFromMapbox(source)) {
                boolean isStreetsV8 = this.sourceIsStreetsV8(source);
                for (Layer layer : layers) {
                    PropertyValue textFieldProperty;
                    if (!(layer instanceof SymbolLayer) || !(textFieldProperty = ((SymbolLayer)layer).getTextField()).isExpression()) continue;
                    if (isStreetsV8) {
                        this.convertExpressionV8(mapLocale, layer, textFieldProperty);
                        continue;
                    }
                    boolean isStreetsV7 = this.sourceIsStreetsV7(source);
                    this.convertExpression(mapLocale, layer, textFieldProperty, isStreetsV7);
                }
                continue;
            }
            String url = null;
            if (source instanceof VectorSource) {
                url = ((VectorSource)source).getUrl();
            }
            if (url == null) {
                url = "not found";
            }
            Timber.w((String)"The %s (%s) source is not based on Mapbox Vector Tiles. Supported sources:\n %s", (Object[])new Object[]{source.getId(), url, SUPPORTED_SOURCES});
        }
    }

    private void convertExpression(@NonNull MapLocale mapLocale, Layer layer, PropertyValue<?> textFieldProperty, boolean isStreetsV7) {
        Expression textFieldExpression = textFieldProperty.getExpression();
        if (textFieldExpression != null) {
            String text;
            MapLocale newMapLocale = mapLocale;
            String mapLanguage = mapLocale.getMapLanguage();
            if (mapLanguage.startsWith("name_zh")) {
                newMapLocale = this.getChineseMapLocale(mapLocale, isStreetsV7);
                Timber.d((String)"reset mapLocale to: %s", (Object[])new Object[]{newMapLocale.getMapLanguage()});
            }
            if ((text = textFieldExpression.toString().replaceAll(EXPRESSION_REGEX, newMapLocale.getMapLanguage())).startsWith("[\"step") && textFieldExpression.toArray().length % 2 == 0) {
                text = text.replaceAll(STEP_REGEX, STEP_TEMPLATE);
            }
            layer.setProperties(new PropertyValue[]{PropertyFactory.textField((Expression)Expression.raw((String)text))});
        }
    }

    private void convertExpressionV8(@NonNull MapLocale mapLocale, Layer layer, PropertyValue<?> textFieldProperty) {
        Expression textFieldExpression = textFieldProperty.getExpression();
        if (textFieldExpression != null) {
            String stringExpression = textFieldExpression.toString().replaceAll(EXPRESSION_V8_REGEX_LOCALIZED, EXPRESSION_V8_TEMPLATE_BASE);
            String mapLanguage = mapLocale.getMapLanguage();
            if (!mapLanguage.equals("name_en")) {
                if (mapLanguage.equals("name_zh")) {
                    mapLanguage = "name_zh-Hans";
                }
                stringExpression = stringExpression.replaceAll(EXPRESSION_V8_REGEX_BASE, String.format(Locale.US, EXPRESSION_V8_TEMPLATE_LOCALIZED, mapLanguage, mapLanguage));
            }
            layer.setProperties(new PropertyValue[]{PropertyFactory.textField((Expression)Expression.raw((String)stringExpression))});
        }
    }

    public void setCameraToLocaleCountry(int padding) {
        this.setCameraToLocaleCountry(Locale.getDefault(), padding);
    }

    public void setCameraToLocaleCountry(Locale locale, int padding) {
        MapLocale mapLocale = MapLocale.getMapLocale(locale, false);
        if (mapLocale != null) {
            this.setCameraToLocaleCountry(mapLocale, padding);
        } else {
            Timber.e((String)"Couldn't match Locale %s to a MapLocale", (Object[])new Object[]{locale.getDisplayName()});
        }
    }

    public void setCameraToLocaleCountry(MapLocale mapLocale, int padding) {
        LatLngBounds bounds = mapLocale.getCountryBounds();
        if (bounds == null) {
            throw new NullPointerException("Expected a LatLngBounds object but received null instead. Make sure your MapLocale instance also has a country bounding box defined.");
        }
        this.mapboxMap.moveCamera(CameraUpdateFactory.newLatLngBounds((LatLngBounds)bounds, (int)padding));
    }

    private boolean sourceIsFromMapbox(Source singleSource) {
        String url;
        if (singleSource instanceof VectorSource && (url = ((VectorSource)singleSource).getUrl()) != null) {
            for (String supportedSource : SUPPORTED_SOURCES) {
                if (!url.contains(supportedSource)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean sourceIsStreetsV7(Source source) {
        if (source instanceof VectorSource) {
            String url = ((VectorSource)source).getUrl();
            return url != null && url.contains("mapbox.mapbox-streets-v7");
        }
        return false;
    }

    private boolean sourceIsStreetsV8(Source source) {
        if (source instanceof VectorSource) {
            String url = ((VectorSource)source).getUrl();
            return url != null && url.contains("mapbox.mapbox-streets-v8");
        }
        return false;
    }

    static {
        SUPPORTED_SOURCES.add("mapbox.mapbox-streets-v6");
        SUPPORTED_SOURCES.add("mapbox.mapbox-streets-v7");
        SUPPORTED_SOURCES.add("mapbox.mapbox-streets-v8");
    }
}

