package com.mapbox.mapboxsdk.plugins.china.shift;

/**
 * Centralises the knowledge about "shift-for-china" library loading.
 */
public class ShiftForChina {
  /**
   * Loads "shift-for-china" native shared library.
   */
  static {
    System.loadLibrary("shift-for-china");
  }

  /**
   * Shifts WGS-84 "global" coordinates to the equivalent GCJ-02 "China" coordinates.
   *
   * @param lon The unshifted longitude
   * @param lat The unshifted latitude
   * @return A String which representing a JSONObject
   */
  public String shift(double lon, double lat) {
    return nativeShift(lon, lat);
  }

  /**
   * Do not use this method. Use {@see shift()} instead. This method uses the native shifting
   * module to do the coordinate conversion.
   */
  private native String nativeShift(double lon, double lat);
}
