/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.china.maps;

import com.mapbox.mapboxsdk.storage.FileSource;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChinaStyleMapper
implements FileSource.ResourceTransformCallback {
    private static final int STYLE_COUNT = 3;
    static String[] originalSuffix = new String[3];
    static String[] chinaSuffix = new String[3];

    public String onURL(int kind, String url) {
        if (kind == 1) {
            if (url.contains("zh-v")) {
                return url;
            }
            for (int i = 0; i < 3; ++i) {
                if (!url.contains(originalSuffix[i])) continue;
                return url.replace(originalSuffix[i], chinaSuffix[i]);
            }
            Pattern pattern = Pattern.compile("v1/.*\\?");
            Matcher matcher = pattern.matcher(url);
            return matcher.replaceAll("v1/" + chinaSuffix[0] + "?");
        }
        return url;
    }

    static {
        ChinaStyleMapper.originalSuffix[0] = "mapbox://styles/mapbox/streets-v11".split("styles/")[1];
        ChinaStyleMapper.chinaSuffix[0] = "mapbox://styles/mapbox/streets-zh-v1".split("styles/")[1];
        ChinaStyleMapper.originalSuffix[1] = "mapbox://styles/mapbox/light-v10".split("styles/")[1];
        ChinaStyleMapper.chinaSuffix[1] = "mapbox://styles/mapbox/light-zh-v1".split("styles/")[1];
        ChinaStyleMapper.originalSuffix[2] = "mapbox://styles/mapbox/dark-v10".split("styles/")[1];
        ChinaStyleMapper.chinaSuffix[2] = "mapbox://styles/mapbox/dark-zh-v1".split("styles/")[1];
    }
}

