package com.mapbox.mapboxsdk.plugins.china.maps;

import com.mapbox.mapboxsdk.constants.Style;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.plugins.china.constants.ChinaStyle;
import com.mapbox.mapboxsdk.plugins.china.constants.MapboxChinaConstants;

/**
 * Set map base URL and styles for a Mapbox China map.
 */
public class MapboxMapChinaOptions extends MapboxMapOptions {

  public static MapboxMapOptions convert(MapboxMapOptions mapboxMapOptions) {

    // Set the map API base URL to the CN endpoint so that China map tiles load
    mapboxMapOptions.apiBaseUrl(MapboxChinaConstants.BASE_API_URL);

    // Check to see if the style needs to be adjusted. First, there is a check to account for
    // the usage of a China map style that's alternative to the latest version. For example,
    // the version #1 of China Streets, rather than a later version. The second is check for
    // a global Mapbox style or an alternative map style URL that is incompatible with Mapbox
    // China map tiles.
    String style = mapboxMapOptions.getStyleUrl();
    if (style != null && !style.isEmpty()) {

      // if/else statement accounts for the fact that a specific China map style version could've
      // been set as the map option styleUrl
      if (style.contains("zh-v")) {
        return mapboxMapOptions;
      }

      // If the code has made it to this switch statement, a specific China map style hasn't been
      // requested via ChinaStyle#specificChinaStyleVersion()
      switch (style) {
        case Style.LIGHT:
          mapboxMapOptions.styleUrl(ChinaStyle.MAPBOX_LIGHT_CHINESE);
          break;
        case Style.DARK:
          mapboxMapOptions.styleUrl(ChinaStyle.MAPBOX_DARK_CHINESE);
          break;
        default:
          mapboxMapOptions.styleUrl(ChinaStyle.MAPBOX_STREETS_CHINESE);
          break;
      }
    } else {
      mapboxMapOptions.styleUrl(ChinaStyle.MAPBOX_STREETS_CHINESE);
    }
    return mapboxMapOptions;
  }
}
