package com.mapbox.mapboxsdk.plugins.china.shift;

import android.location.Location;

import org.json.JSONException;
import org.json.JSONObject;

/*
 * The class shifts location which is from device into the right mapping location on Mapbox map in china.
 */
public class ShiftLocation {
  private static ShiftForChina shiftForChina = new ShiftForChina();

  /**
   * This method transfers the location from devices to the shifted location.
   */
  public static Location shift(Location fromLocation) {
    Location toLocation = new Location(fromLocation);
    String toJson = shiftForChina.shift(fromLocation.getLongitude(), fromLocation.getLatitude());
    try {
      JSONObject jsonObject = new JSONObject(toJson);
      toLocation.setLongitude(jsonObject.getDouble("lon"));
      toLocation.setLatitude(jsonObject.getDouble("lat"));
    } catch (JSONException jsonException) {
      jsonException.printStackTrace();
    }
    return toLocation;
  }
}
