package com.mapbox.mapboxsdk.plugins.china.services;

import com.mapbox.api.directions.v5.MapboxDirections;
import com.mapbox.mapboxsdk.plugins.china.constants.MapboxChinaConstants;

/**
 * Use the static builder inside this class rather than the one provided inside the
 * {@link MapboxDirections} class so more optimal values are set by default for the China region.
 * <p>
 * The Directions API allows the calculation of routes between coordinates. The fastest route can be
 * returned with geometries, turn-by-turn instructions, and much more. The Mapbox Directions API
 * supports routing for driving cars (including live traffic), riding bicycles and walking.
 * Requested routes can include as much as 25 coordinates anywhere on earth (except the traffic
 * profile).
 * </p><p>
 * Requesting a route at a bare minimal must include, a Mapbox access token, destination, and an
 * origin.
 * </p>
 *
 * @see <a href="https://www.mapbox.com/android-docs/java-sdk/overview/directions/">Android
 *   Directions documentation</a>
 * @see <a href="https://www.mapbox.com/api-documentation/#directions">Directions API
 *   documentation</a>
 * @since 1.0.0
 */
public abstract class MapboxDirectionsChina {

  private MapboxDirectionsChina() {
    // No Instances
  }

  public static MapboxDirections.Builder builder() {
    return MapboxDirections.builder()
      .baseUrl(MapboxChinaConstants.BASE_API_URL);
  }
}
