package com.mapbox.mapboxsdk.plugins.china.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;

import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.plugins.china.BuildConfig;
import com.mapbox.mapboxsdk.plugins.china.R;
import com.mapbox.mapboxsdk.plugins.china.constants.MapboxChinaConstants;
import com.mapbox.mapboxsdk.plugins.china.constants.ChinaStyle;

/**
 * set map base url and style for China map.
 */
public class MapboxMapChinaOptions extends MapboxMapOptions {

  public static MapboxMapOptions createFromAttributes(@NonNull Context context,
                                                      @Nullable AttributeSet attrs) {
    MapboxMapOptions options = MapboxMapOptions.createFromAttributes(context, attrs);
    TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.mapbox_MapView, 0, 0);
    try {
      if (typedArray.getString(R.styleable.mapbox_MapView_mapbox_apiBaseUrl) == null) {
        options.apiBaseUrl(MapboxChinaConstants.BASE_API_URL);
      }
      if (typedArray.getString(R.styleable.mapbox_MapView_mapbox_styleUrl) == null) {
        options.styleUrl(ChinaStyle.MAPBOX_STREETS_CHINESE);
      }
    } finally {
      typedArray.recycle();
    }
    return options;
  }

  public MapboxMapChinaOptions() {
    super();
    // Skip setting the china values if using global flavor of plugin
    if (BuildConfig.FLAVOR.contains(MapboxChinaConstants.FLAVOR_GLOBAL)) {
      return;
    }
    apiBaseUrl(MapboxChinaConstants.BASE_API_URL);
    styleUrl(ChinaStyle.MAPBOX_STREETS_CHINESE);
  }
}
