/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.china.lint;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/mapbox/mapboxsdk/plugins/china/lint/WrongMapboxChinaUsageDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Companion", "china-lint"})
public final class WrongMapboxChinaUsageDetector
extends LayoutDetector {
    private static final String INCORRECT_MAPVIEW = "com.mapbox.mapboxsdk.maps.MapView";
    private static final String CORRECT_MAPVIEW = "com.mapbox.mapboxsdk.plugins.china.maps.ChinaMapView";
    private static final String REPORT_MESSAGE = "ChinaMapView should be used rather than MapView to ensure optimal performance.";
    @NotNull
    private static final Issue ISSUE_NOT_CHINA_MAPVIEW;
    public static final Companion Companion;

    @NotNull
    public List<String> getApplicableElements() {
        List list = LayoutDetector.ALL;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"LayoutDetector.ALL");
        return list;
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        String string = element.getTagName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.tagName");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)INCORRECT_MAPVIEW, (boolean)false, (int)2, null)) {
            String string2 = element.getTagName();
            System.out.println((Object)string2);
            LintFix.ReplaceStringBuilder replaceStringBuilder = this.fix().replace().name("Change to ChinaMapView").text(element.getTagName());
            String string3 = element.getTagName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"element.tagName");
            LintFix quickFix = replaceStringBuilder.with(StringsKt.replace$default((String)string3, (String)INCORRECT_MAPVIEW, (String)CORRECT_MAPVIEW, (boolean)false, (int)4, null)).build();
            context.report(ISSUE_NOT_CHINA_MAPVIEW, (Node)element, context.getLocation((Node)element), REPORT_MESSAGE, quickFix);
        }
    }

    static {
        Companion = new Companion(null);
        ISSUE_NOT_CHINA_MAPVIEW = Issue.Companion.create("NotChinaMapView", "ChinaMapView should be used rather than MapView", "ChinaMapView is an extension of MapView and sets the default parameters to appropriate ones that should be used in China.", Category.USABILITY, 8, Severity.ERROR, new Implementation(WrongMapboxChinaUsageDetector.class, Scope.RESOURCE_FILE_SCOPE));
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/mapbox/mapboxsdk/plugins/china/lint/WrongMapboxChinaUsageDetector$Companion;", "", "()V", "CORRECT_MAPVIEW", "", "INCORRECT_MAPVIEW", "ISSUE_NOT_CHINA_MAPVIEW", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE_NOT_CHINA_MAPVIEW", "()Lcom/android/tools/lint/detector/api/Issue;", "REPORT_MESSAGE", "china-lint"})
    public static final class Companion {
        @NotNull
        public final Issue getISSUE_NOT_CHINA_MAPVIEW() {
            return ISSUE_NOT_CHINA_MAPVIEW;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

