/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.JsonObject;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.plugins.annotation.Line;
import com.mapbox.mapboxsdk.plugins.annotation.Options;
import java.util.ArrayList;
import java.util.List;

public class LineOptions
extends Options<Line> {
    private boolean isDraggable;
    private LineString geometry;
    private String lineJoin;
    private Float lineOpacity;
    private String lineColor;
    private Float lineWidth;
    private Float lineGapWidth;
    private Float lineOffset;
    private Float lineBlur;
    private String linePattern;

    public LineOptions withLineJoin(String lineJoin) {
        this.lineJoin = lineJoin;
        return this;
    }

    public String getLineJoin() {
        return this.lineJoin;
    }

    public LineOptions withLineOpacity(Float lineOpacity) {
        this.lineOpacity = lineOpacity;
        return this;
    }

    public Float getLineOpacity() {
        return this.lineOpacity;
    }

    public LineOptions withLineColor(String lineColor) {
        this.lineColor = lineColor;
        return this;
    }

    public String getLineColor() {
        return this.lineColor;
    }

    public LineOptions withLineWidth(Float lineWidth) {
        this.lineWidth = lineWidth;
        return this;
    }

    public Float getLineWidth() {
        return this.lineWidth;
    }

    public LineOptions withLineGapWidth(Float lineGapWidth) {
        this.lineGapWidth = lineGapWidth;
        return this;
    }

    public Float getLineGapWidth() {
        return this.lineGapWidth;
    }

    public LineOptions withLineOffset(Float lineOffset) {
        this.lineOffset = lineOffset;
        return this;
    }

    public Float getLineOffset() {
        return this.lineOffset;
    }

    public LineOptions withLineBlur(Float lineBlur) {
        this.lineBlur = lineBlur;
        return this;
    }

    public Float getLineBlur() {
        return this.lineBlur;
    }

    public LineOptions withLinePattern(String linePattern) {
        this.linePattern = linePattern;
        return this;
    }

    public String getLinePattern() {
        return this.linePattern;
    }

    public LineOptions withLatLngs(List<LatLng> latLngs) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (LatLng latLng : latLngs) {
            points.add(Point.fromLngLat((double)latLng.getLongitude(), (double)latLng.getLatitude()));
        }
        this.geometry = LineString.fromLngLats(points);
        return this;
    }

    public LineOptions withGeometry(LineString geometry) {
        this.geometry = geometry;
        return this;
    }

    public boolean isDraggable() {
        return this.isDraggable;
    }

    public LineOptions setDraggable(boolean draggable) {
        this.isDraggable = draggable;
        return this;
    }

    @Override
    Line build(long id, AnnotationManager<?, Line, ?, ?, ?, ?> annotationManager) {
        if (this.geometry == null) {
            throw new RuntimeException("geometry field is required");
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("line-join", this.lineJoin);
        jsonObject.addProperty("line-opacity", (Number)this.lineOpacity);
        jsonObject.addProperty("line-color", this.lineColor);
        jsonObject.addProperty("line-width", (Number)this.lineWidth);
        jsonObject.addProperty("line-gap-width", (Number)this.lineGapWidth);
        jsonObject.addProperty("line-offset", (Number)this.lineOffset);
        jsonObject.addProperty("line-blur", (Number)this.lineBlur);
        jsonObject.addProperty("line-pattern", this.linePattern);
        Line line = new Line(id, annotationManager, jsonObject, this.geometry);
        line.setDraggable(this.isDraggable);
        return line;
    }

    @Nullable
    static LineOptions fromFeature(@NonNull Feature feature) {
        if (feature.geometry() == null) {
            throw new RuntimeException("geometry field is required");
        }
        if (!(feature.geometry() instanceof LineString)) {
            return null;
        }
        LineOptions options = new LineOptions();
        options.geometry = (LineString)feature.geometry();
        if (feature.hasProperty("line-join")) {
            options.lineJoin = feature.getProperty("line-join").getAsString();
        }
        if (feature.hasProperty("line-opacity")) {
            options.lineOpacity = Float.valueOf(feature.getProperty("line-opacity").getAsFloat());
        }
        if (feature.hasProperty("line-color")) {
            options.lineColor = feature.getProperty("line-color").getAsString();
        }
        if (feature.hasProperty("line-width")) {
            options.lineWidth = Float.valueOf(feature.getProperty("line-width").getAsFloat());
        }
        if (feature.hasProperty("line-gap-width")) {
            options.lineGapWidth = Float.valueOf(feature.getProperty("line-gap-width").getAsFloat());
        }
        if (feature.hasProperty("line-offset")) {
            options.lineOffset = Float.valueOf(feature.getProperty("line-offset").getAsFloat());
        }
        if (feature.hasProperty("line-blur")) {
            options.lineBlur = Float.valueOf(feature.getProperty("line-blur").getAsFloat());
        }
        if (feature.hasProperty("line-pattern")) {
            options.linePattern = feature.getProperty("line-pattern").getAsString();
        }
        if (feature.hasProperty("is-draggable")) {
            options.isDraggable = feature.getProperty("is-draggable").getAsBoolean();
        }
        return options;
    }
}

