/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.annotation.VisibleForTesting;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.plugins.annotation.CoreElementProvider;
import com.mapbox.mapboxsdk.plugins.annotation.DraggableAnnotationController;
import com.mapbox.mapboxsdk.plugins.annotation.Line;
import com.mapbox.mapboxsdk.plugins.annotation.LineOptions;
import com.mapbox.mapboxsdk.plugins.annotation.OnLineClickListener;
import com.mapbox.mapboxsdk.plugins.annotation.OnLineDragListener;
import com.mapbox.mapboxsdk.plugins.annotation.OnLineLongClickListener;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.LineLayer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import java.util.ArrayList;
import java.util.List;

public class LineManager
extends AnnotationManager<LineLayer, Line, LineOptions, OnLineDragListener, OnLineClickListener, OnLineLongClickListener> {
    public static final String ID_GEOJSON_SOURCE = "mapbox-android-line-source";
    public static final String ID_GEOJSON_LAYER = "mapbox-android-line-layer";

    @UiThread
    public LineManager(@NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @NonNull Style style) {
        this(mapView, mapboxMap, style, null);
    }

    @UiThread
    public LineManager(@NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @NonNull Style style, @Nullable String belowLayerId) {
        this(mapView, mapboxMap, style, new CoreElementProvider<LineLayer>(){

            @Override
            public LineLayer getLayer() {
                return new LineLayer(LineManager.ID_GEOJSON_LAYER, LineManager.ID_GEOJSON_SOURCE);
            }

            @Override
            public GeoJsonSource getSource() {
                return new GeoJsonSource(LineManager.ID_GEOJSON_SOURCE);
            }
        }, belowLayerId, new DraggableAnnotationController<Line, OnLineDragListener>(mapView, mapboxMap));
    }

    @VisibleForTesting
    public LineManager(@NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @NonNull Style style, @NonNull CoreElementProvider<LineLayer> coreElementProvider, @Nullable String belowLayerId, DraggableAnnotationController<Line, OnLineDragListener> draggableAnnotationController) {
        super(mapView, mapboxMap, style, coreElementProvider, null, draggableAnnotationController, belowLayerId);
    }

    @Override
    void initializeDataDrivenPropertyMap() {
        this.dataDrivenPropertyUsageMap.put("line-join", false);
        this.dataDrivenPropertyUsageMap.put("line-opacity", false);
        this.dataDrivenPropertyUsageMap.put("line-color", false);
        this.dataDrivenPropertyUsageMap.put("line-width", false);
        this.dataDrivenPropertyUsageMap.put("line-gap-width", false);
        this.dataDrivenPropertyUsageMap.put("line-offset", false);
        this.dataDrivenPropertyUsageMap.put("line-blur", false);
        this.dataDrivenPropertyUsageMap.put("line-pattern", false);
    }

    @Override
    protected void setDataDrivenPropertyIsUsed(@NonNull String property) {
        switch (property) {
            case "line-join": {
                ((LineLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.lineJoin((Expression)Expression.get((String)"line-join"))});
                break;
            }
            case "line-opacity": {
                ((LineLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.lineOpacity((Expression)Expression.get((String)"line-opacity"))});
                break;
            }
            case "line-color": {
                ((LineLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.lineColor((Expression)Expression.get((String)"line-color"))});
                break;
            }
            case "line-width": {
                ((LineLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.lineWidth((Expression)Expression.get((String)"line-width"))});
                break;
            }
            case "line-gap-width": {
                ((LineLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.lineGapWidth((Expression)Expression.get((String)"line-gap-width"))});
                break;
            }
            case "line-offset": {
                ((LineLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.lineOffset((Expression)Expression.get((String)"line-offset"))});
                break;
            }
            case "line-blur": {
                ((LineLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.lineBlur((Expression)Expression.get((String)"line-blur"))});
                break;
            }
            case "line-pattern": {
                ((LineLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.linePattern((Expression)Expression.get((String)"line-pattern"))});
            }
        }
    }

    @Override
    @UiThread
    public List<Line> create(@NonNull String json) {
        return this.create(FeatureCollection.fromJson((String)json));
    }

    @Override
    @UiThread
    public List<Line> create(@NonNull FeatureCollection featureCollection) {
        List features = featureCollection.features();
        ArrayList<LineOptions> options = new ArrayList<LineOptions>();
        if (features != null) {
            for (Feature feature : features) {
                LineOptions option = LineOptions.fromFeature(feature);
                if (option == null) continue;
                options.add(option);
            }
        }
        return this.create(options);
    }

    @Override
    String getAnnotationLayerId() {
        return ID_GEOJSON_LAYER;
    }

    @Override
    String getAnnotationIdKey() {
        return "id";
    }

    public String getLineCap() {
        return (String)((LineLayer)this.layer).getLineCap().value;
    }

    public void setLineCap(String value) {
        PropertyValue propertyValue = PropertyFactory.lineCap((String)value);
        this.constantPropertyUsageMap.put("line-cap", propertyValue);
        ((LineLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public Float getLineMiterLimit() {
        return (Float)((LineLayer)this.layer).getLineMiterLimit().value;
    }

    public void setLineMiterLimit(Float value) {
        PropertyValue propertyValue = PropertyFactory.lineMiterLimit((Float)value);
        this.constantPropertyUsageMap.put("line-miter-limit", propertyValue);
        ((LineLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public Float getLineRoundLimit() {
        return (Float)((LineLayer)this.layer).getLineRoundLimit().value;
    }

    public void setLineRoundLimit(Float value) {
        PropertyValue propertyValue = PropertyFactory.lineRoundLimit((Float)value);
        this.constantPropertyUsageMap.put("line-round-limit", propertyValue);
        ((LineLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public Float[] getLineTranslate() {
        return (Float[])((LineLayer)this.layer).getLineTranslate().value;
    }

    public void setLineTranslate(Float[] value) {
        PropertyValue propertyValue = PropertyFactory.lineTranslate((Float[])value);
        this.constantPropertyUsageMap.put("line-translate", propertyValue);
        ((LineLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public String getLineTranslateAnchor() {
        return (String)((LineLayer)this.layer).getLineTranslateAnchor().value;
    }

    public void setLineTranslateAnchor(String value) {
        PropertyValue propertyValue = PropertyFactory.lineTranslateAnchor((String)value);
        this.constantPropertyUsageMap.put("line-translate-anchor", propertyValue);
        ((LineLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public Float[] getLineDasharray() {
        return (Float[])((LineLayer)this.layer).getLineDasharray().value;
    }

    public void setLineDasharray(Float[] value) {
        PropertyValue propertyValue = PropertyFactory.lineDasharray((Float[])value);
        this.constantPropertyUsageMap.put("line-dasharray", propertyValue);
        ((LineLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    @Override
    public void setFilter(@NonNull Expression expression) {
        this.layerFilter = expression;
        ((LineLayer)this.layer).setFilter(this.layerFilter);
    }

    @Nullable
    public Expression getFilter() {
        return ((LineLayer)this.layer).getFilter();
    }
}

