/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.JsonObject;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.plugins.annotation.Circle;
import com.mapbox.mapboxsdk.plugins.annotation.Options;

public class CircleOptions
extends Options<Circle> {
    private boolean isDraggable;
    private Point geometry;
    private Float circleRadius;
    private String circleColor;
    private Float circleBlur;
    private Float circleOpacity;
    private Float circleStrokeWidth;
    private String circleStrokeColor;
    private Float circleStrokeOpacity;

    public CircleOptions withCircleRadius(Float circleRadius) {
        this.circleRadius = circleRadius;
        return this;
    }

    public Float getCircleRadius() {
        return this.circleRadius;
    }

    public CircleOptions withCircleColor(String circleColor) {
        this.circleColor = circleColor;
        return this;
    }

    public String getCircleColor() {
        return this.circleColor;
    }

    public CircleOptions withCircleBlur(Float circleBlur) {
        this.circleBlur = circleBlur;
        return this;
    }

    public Float getCircleBlur() {
        return this.circleBlur;
    }

    public CircleOptions withCircleOpacity(Float circleOpacity) {
        this.circleOpacity = circleOpacity;
        return this;
    }

    public Float getCircleOpacity() {
        return this.circleOpacity;
    }

    public CircleOptions withCircleStrokeWidth(Float circleStrokeWidth) {
        this.circleStrokeWidth = circleStrokeWidth;
        return this;
    }

    public Float getCircleStrokeWidth() {
        return this.circleStrokeWidth;
    }

    public CircleOptions withCircleStrokeColor(String circleStrokeColor) {
        this.circleStrokeColor = circleStrokeColor;
        return this;
    }

    public String getCircleStrokeColor() {
        return this.circleStrokeColor;
    }

    public CircleOptions withCircleStrokeOpacity(Float circleStrokeOpacity) {
        this.circleStrokeOpacity = circleStrokeOpacity;
        return this;
    }

    public Float getCircleStrokeOpacity() {
        return this.circleStrokeOpacity;
    }

    public CircleOptions withLatLng(LatLng latLng) {
        this.geometry = Point.fromLngLat((double)latLng.getLongitude(), (double)latLng.getLatitude());
        return this;
    }

    public CircleOptions withGeometry(Point geometry) {
        this.geometry = geometry;
        return this;
    }

    public boolean isDraggable() {
        return this.isDraggable;
    }

    public CircleOptions setDraggable(boolean draggable) {
        this.isDraggable = draggable;
        return this;
    }

    @Override
    Circle build(long id, AnnotationManager<?, Circle, ?, ?, ?, ?> annotationManager) {
        if (this.geometry == null) {
            throw new RuntimeException("geometry field is required");
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("circle-radius", (Number)this.circleRadius);
        jsonObject.addProperty("circle-color", this.circleColor);
        jsonObject.addProperty("circle-blur", (Number)this.circleBlur);
        jsonObject.addProperty("circle-opacity", (Number)this.circleOpacity);
        jsonObject.addProperty("circle-stroke-width", (Number)this.circleStrokeWidth);
        jsonObject.addProperty("circle-stroke-color", this.circleStrokeColor);
        jsonObject.addProperty("circle-stroke-opacity", (Number)this.circleStrokeOpacity);
        Circle circle = new Circle(id, annotationManager, jsonObject, this.geometry);
        circle.setDraggable(this.isDraggable);
        return circle;
    }

    @Nullable
    static CircleOptions fromFeature(@NonNull Feature feature) {
        if (feature.geometry() == null) {
            throw new RuntimeException("geometry field is required");
        }
        if (!(feature.geometry() instanceof Point)) {
            return null;
        }
        CircleOptions options = new CircleOptions();
        options.geometry = (Point)feature.geometry();
        if (feature.hasProperty("circle-radius")) {
            options.circleRadius = Float.valueOf(feature.getProperty("circle-radius").getAsFloat());
        }
        if (feature.hasProperty("circle-color")) {
            options.circleColor = feature.getProperty("circle-color").getAsString();
        }
        if (feature.hasProperty("circle-blur")) {
            options.circleBlur = Float.valueOf(feature.getProperty("circle-blur").getAsFloat());
        }
        if (feature.hasProperty("circle-opacity")) {
            options.circleOpacity = Float.valueOf(feature.getProperty("circle-opacity").getAsFloat());
        }
        if (feature.hasProperty("circle-stroke-width")) {
            options.circleStrokeWidth = Float.valueOf(feature.getProperty("circle-stroke-width").getAsFloat());
        }
        if (feature.hasProperty("circle-stroke-color")) {
            options.circleStrokeColor = feature.getProperty("circle-stroke-color").getAsString();
        }
        if (feature.hasProperty("circle-stroke-opacity")) {
            options.circleStrokeOpacity = Float.valueOf(feature.getProperty("circle-stroke-opacity").getAsFloat());
        }
        if (feature.hasProperty("is-draggable")) {
            options.isDraggable = feature.getProperty("is-draggable").getAsBoolean();
        }
        return options;
    }
}

