/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.gestures;

import android.content.Context;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import androidx.annotation.NonNull;
import androidx.annotation.UiThread;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.MultiFingerGesture;
import java.util.Set;

@UiThread
public abstract class ProgressiveGesture<L>
extends MultiFingerGesture<L> {
    private final Set<Integer> handledTypes = this.provideHandledTypes();
    private boolean isInProgress;
    private boolean interrupted;
    VelocityTracker velocityTracker;
    float velocityX;
    float velocityY;

    public ProgressiveGesture(Context context, AndroidGesturesManager gesturesManager) {
        super(context, gesturesManager);
    }

    @NonNull
    protected abstract Set<Integer> provideHandledTypes();

    @Override
    protected boolean analyzeEvent(@NonNull MotionEvent motionEvent) {
        int action = motionEvent.getActionMasked();
        if (action == 0 || action == 5 || action == 6 || action == 3) {
            this.reset();
        }
        if (this.interrupted) {
            this.interrupted = false;
            this.reset();
            this.gestureStopped();
        }
        if (this.velocityTracker != null) {
            this.velocityTracker.addMovement(this.getCurrentEvent());
        }
        boolean movementHandled = super.analyzeEvent(motionEvent);
        if (action == 1 || action == 6) {
            if (this.pointerIdList.size() < this.getRequiredPointersCount() && this.isInProgress) {
                this.gestureStopped();
                return true;
            }
        } else if (action == 3 && this.isInProgress) {
            this.gestureStopped();
            return true;
        }
        return movementHandled;
    }

    protected void gestureStarted() {
        this.isInProgress = true;
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
    }

    protected void gestureStopped() {
        this.isInProgress = false;
        if (this.velocityTracker != null) {
            this.velocityTracker.computeCurrentVelocity(1000);
            this.velocityX = this.velocityTracker.getXVelocity();
            this.velocityY = this.velocityTracker.getYVelocity();
            this.velocityTracker.recycle();
            this.velocityTracker = null;
        }
        this.reset();
    }

    Set<Integer> getHandledTypes() {
        return this.handledTypes;
    }

    public boolean isInProgress() {
        return this.isInProgress;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.interrupt();
        }
    }

    public void interrupt() {
        if (this.isInProgress()) {
            this.interrupted = true;
        }
    }
}

