/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.gestures;

import android.content.Context;
import android.view.MotionEvent;
import androidx.annotation.DimenRes;
import androidx.annotation.NonNull;
import androidx.annotation.UiThread;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.MultiFingerDistancesObject;
import com.mapbox.android.gestures.MultiFingerGesture;
import com.mapbox.android.gestures.PointerDistancePair;
import java.util.HashMap;

@UiThread
public class MultiFingerTapGestureDetector
extends MultiFingerGesture<OnMultiFingerTapGestureListener> {
    private long multiFingerTapTimeThreshold;
    private float multiFingerTapMovementThreshold;
    private boolean invalidMovement;
    private boolean pointerLifted;
    private int lastPointersDownCount;

    public MultiFingerTapGestureDetector(Context context, AndroidGesturesManager gesturesManager) {
        super(context, gesturesManager);
    }

    @Override
    protected boolean analyzeEvent(@NonNull MotionEvent motionEvent) {
        super.analyzeEvent(motionEvent);
        int action = motionEvent.getActionMasked();
        switch (action) {
            case 5: {
                if (this.pointerLifted) {
                    this.invalidMovement = true;
                }
                this.lastPointersDownCount = this.pointerIdList.size();
                break;
            }
            case 6: {
                this.pointerLifted = true;
                break;
            }
            case 1: {
                boolean canExecute = this.canExecute(4);
                boolean handled = false;
                if (canExecute) {
                    handled = ((OnMultiFingerTapGestureListener)this.listener).onMultiFingerTap(this, this.lastPointersDownCount);
                }
                this.reset();
                return handled;
            }
            case 2: {
                if (this.invalidMovement) break;
                this.invalidMovement = this.exceededMovementThreshold(this.pointersDistanceMap);
                break;
            }
        }
        return false;
    }

    boolean exceededMovementThreshold(HashMap<PointerDistancePair, MultiFingerDistancesObject> map) {
        for (MultiFingerDistancesObject distancesObject : map.values()) {
            float diffX = Math.abs(distancesObject.getCurrFingersDiffX() - distancesObject.getPrevFingersDiffX());
            float diffY = Math.abs(distancesObject.getCurrFingersDiffY() - distancesObject.getPrevFingersDiffY());
            boolean bl = this.invalidMovement = diffX > this.multiFingerTapMovementThreshold || diffY > this.multiFingerTapMovementThreshold;
            if (!this.invalidMovement) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean canExecute(int invokedGestureType) {
        return this.lastPointersDownCount > 1 && !this.invalidMovement && this.getGestureDuration() < this.multiFingerTapTimeThreshold && super.canExecute(invokedGestureType);
    }

    @Override
    protected void reset() {
        super.reset();
        this.lastPointersDownCount = 0;
        this.invalidMovement = false;
        this.pointerLifted = false;
    }

    public long getMultiFingerTapTimeThreshold() {
        return this.multiFingerTapTimeThreshold;
    }

    public void setMultiFingerTapTimeThreshold(long multiFingerTapTimeThreshold) {
        this.multiFingerTapTimeThreshold = multiFingerTapTimeThreshold;
    }

    public float getMultiFingerTapMovementThreshold() {
        return this.multiFingerTapMovementThreshold;
    }

    public void setMultiFingerTapMovementThreshold(float multiFingerTapMovementThreshold) {
        this.multiFingerTapMovementThreshold = multiFingerTapMovementThreshold;
    }

    public void setMultiFingerTapMovementThresholdResource(@DimenRes int multiFingerTapMovementThresholdDimen) {
        this.setMultiFingerTapMovementThreshold(this.context.getResources().getDimension(multiFingerTapMovementThresholdDimen));
    }

    public static interface OnMultiFingerTapGestureListener {
        public boolean onMultiFingerTap(@NonNull MultiFingerTapGestureDetector var1, int var2);
    }
}

