/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.gestures;

import android.content.Context;
import android.view.MotionEvent;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.ProgressiveGesture;
import java.util.Set;

@UiThread
public abstract class BaseGesture<L> {
    protected final Context context;
    protected final WindowManager windowManager;
    private final AndroidGesturesManager gesturesManager;
    private MotionEvent currentEvent;
    private MotionEvent previousEvent;
    private long gestureDuration;
    private boolean isEnabled = true;
    protected L listener;

    public BaseGesture(Context context, AndroidGesturesManager gesturesManager) {
        this.context = context;
        this.windowManager = (WindowManager)context.getSystemService("window");
        this.gesturesManager = gesturesManager;
    }

    protected boolean onTouchEvent(MotionEvent motionEvent) {
        return this.analyze(motionEvent);
    }

    private boolean analyze(@Nullable MotionEvent motionEvent) {
        if (motionEvent == null) {
            return false;
        }
        if (this.previousEvent != null) {
            this.previousEvent.recycle();
            this.previousEvent = null;
        }
        if (this.currentEvent != null) {
            this.previousEvent = MotionEvent.obtain((MotionEvent)this.currentEvent);
            this.currentEvent.recycle();
            this.currentEvent = null;
        }
        this.currentEvent = MotionEvent.obtain((MotionEvent)motionEvent);
        this.gestureDuration = this.currentEvent.getEventTime() - this.currentEvent.getDownTime();
        return this.analyzeEvent(motionEvent);
    }

    protected abstract boolean analyzeEvent(@NonNull MotionEvent var1);

    protected boolean canExecute(int invokedGestureType) {
        if (this.listener == null || !this.isEnabled) {
            return false;
        }
        for (Set<Integer> exclusives : this.gesturesManager.getMutuallyExclusiveGestures()) {
            if (!exclusives.contains(invokedGestureType)) continue;
            for (int gestureType : exclusives) {
                for (BaseGesture detector : this.gesturesManager.getDetectors()) {
                    ProgressiveGesture progressiveDetector;
                    if (!(detector instanceof ProgressiveGesture) || !(progressiveDetector = (ProgressiveGesture)detector).getHandledTypes().contains(gestureType) || !progressiveDetector.isInProgress()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected void setListener(L listener) {
        this.listener = listener;
    }

    protected void removeListener() {
        this.listener = null;
    }

    public long getGestureDuration() {
        return this.gestureDuration;
    }

    public MotionEvent getCurrentEvent() {
        return this.currentEvent;
    }

    public MotionEvent getPreviousEvent() {
        return this.previousEvent;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }
}

