/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.gestures;

import android.content.Context;
import android.os.Build;
import android.support.annotation.DimenRes;
import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.ProgressiveGesture;
import com.mapbox.android.gestures.R;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;

@UiThread
public class StandardScaleGestureDetector
extends ProgressiveGesture<StandardOnScaleGestureListener> {
    private static final Set<Integer> handledTypes = new HashSet<Integer>();
    private ScaleGestureDetector scaleGestureDetector;
    ScaleGestureDetector.OnScaleGestureListener innerListener = new ScaleGestureDetector.OnScaleGestureListener(){

        public boolean onScale(ScaleGestureDetector detector) {
            return StandardScaleGestureDetector.this.innerOnScale(detector);
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            return StandardScaleGestureDetector.this.innerOnScaleBegin(detector);
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            StandardScaleGestureDetector.this.innerOnScaleEnd(detector);
        }
    };
    private boolean stopConfirmed;
    private boolean isScalingOut;
    float startSpan;
    float spanDeltaSinceStart;
    private float spanSinceStartThreshold;

    public StandardScaleGestureDetector(Context context, AndroidGesturesManager androidGesturesManager) {
        super(context, androidGesturesManager);
        this.scaleGestureDetector = new ScaleGestureDetector(context, this.innerListener);
        try {
            this.modifyInternalMinSpanValues();
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    void modifyInternalMinSpanValues() throws NoSuchFieldException, IllegalAccessException {
        Field minSpanField = this.scaleGestureDetector.getClass().getDeclaredField("mMinSpan");
        minSpanField.setAccessible(true);
        if (Build.VERSION.SDK_INT >= 24) {
            minSpanField.set(this.scaleGestureDetector, (int)this.context.getResources().getDimension(R.dimen.mapbox_internalScaleMinSpan24));
        } else {
            minSpanField.set(this.scaleGestureDetector, (int)this.context.getResources().getDimension(R.dimen.mapbox_internalScaleMinSpan23));
        }
        Field spanSlopField = this.scaleGestureDetector.getClass().getDeclaredField("mSpanSlop");
        spanSlopField.setAccessible(true);
        spanSlopField.set(this.scaleGestureDetector, ViewConfiguration.get((Context)this.context).getScaledTouchSlop());
    }

    boolean innerOnScale(ScaleGestureDetector detector) {
        if (this.startSpan == 0.0f) {
            this.startSpan = detector.getCurrentSpan();
        }
        this.spanDeltaSinceStart = Math.abs(this.startSpan - detector.getCurrentSpan());
        if (!this.isInProgress() && this.canExecute(1) && this.spanDeltaSinceStart >= this.spanSinceStartThreshold) {
            if (((StandardOnScaleGestureListener)this.listener).onScaleBegin(this)) {
                this.gestureStarted();
                return true;
            }
            return false;
        }
        if (this.isInProgress()) {
            this.isScalingOut = detector.getScaleFactor() < 1.0f;
            return ((StandardOnScaleGestureListener)this.listener).onScale(this);
        }
        return true;
    }

    boolean innerOnScaleBegin(ScaleGestureDetector detector) {
        this.startSpan = detector.getCurrentSpan();
        if (this.canExecute(1)) {
            this.velocityTracker = VelocityTracker.obtain();
            if (this.spanSinceStartThreshold == 0.0f && ((StandardOnScaleGestureListener)this.listener).onScaleBegin(this)) {
                this.gestureStarted();
            }
            return true;
        }
        return false;
    }

    void innerOnScaleEnd(ScaleGestureDetector detector) {
        this.stopConfirmed = true;
        this.gestureStopped();
    }

    @Override
    protected boolean analyzeEvent(MotionEvent motionEvent) {
        super.analyzeEvent(motionEvent);
        return this.scaleGestureDetector.onTouchEvent(motionEvent);
    }

    @Override
    protected void gestureStopped() {
        if (!this.isInProgress()) {
            super.gestureStopped();
            return;
        }
        if (this.stopConfirmed) {
            super.gestureStopped();
            ((StandardOnScaleGestureListener)this.listener).onScaleEnd(this, this.velocityX, this.velocityY);
            this.stopConfirmed = false;
        }
    }

    @Override
    public void interrupt() {
        super.interrupt();
        this.stopConfirmed = true;
    }

    @Override
    @NonNull
    protected Set<Integer> provideHandledTypes() {
        return handledTypes;
    }

    public boolean isScalingOut() {
        return this.isScalingOut;
    }

    public ScaleGestureDetector getUnderlyingScaleGestureDetector() {
        return this.scaleGestureDetector;
    }

    public float getSpanSinceStartThreshold() {
        return this.spanSinceStartThreshold;
    }

    public void setSpanSinceStartThreshold(float spanSinceStartThreshold) {
        this.spanSinceStartThreshold = spanSinceStartThreshold;
    }

    public void setSpanSinceStartThresholdResource(@DimenRes int spanSinceStartThresholdDimen) {
        this.setSpanSinceStartThreshold(this.context.getResources().getDimension(spanSinceStartThresholdDimen));
    }

    public float getScaleFactor() {
        return this.scaleGestureDetector.getScaleFactor();
    }

    static {
        handledTypes.add(1);
    }

    public static class SimpleStandardOnScaleGestureListener
    implements StandardOnScaleGestureListener {
        @Override
        public boolean onScaleBegin(StandardScaleGestureDetector detector) {
            return true;
        }

        @Override
        public boolean onScale(StandardScaleGestureDetector detector) {
            return false;
        }

        @Override
        public void onScaleEnd(StandardScaleGestureDetector detector, float velocityX, float velocityY) {
        }
    }

    public static interface StandardOnScaleGestureListener {
        public boolean onScaleBegin(StandardScaleGestureDetector var1);

        public boolean onScale(StandardScaleGestureDetector var1);

        public void onScaleEnd(StandardScaleGestureDetector var1, float var2, float var3);
    }
}

